/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.AWTUtil$1;
import org.lwjgl.opengl.AWTUtil$2;

final class AWTUtil {
    AWTUtil() {
    }

    public static boolean hasWheel() {
        return true;
    }

    public static int getButtonCount() {
        return 3;
    }

    public static int getNativeCursorCapabilities() {
        if (LWJGLUtil.getPlatform() != 2 || LWJGLUtil.isMacOSXEqualsOrBetterThan(10, 4)) {
            int n = Toolkit.getDefaultToolkit().getMaximumCursorColors();
            boolean bl = n >= Short.MAX_VALUE && AWTUtil.getMaxCursorSize() > 0;
            int n2 = bl ? 3 : 4;
            return n2;
        }
        return 0;
    }

    public static Robot createRobot(Component component) {
        try {
            return AccessController.doPrivileged(new AWTUtil$1(component));
        }
        catch (PrivilegedActionException privilegedActionException) {
            LWJGLUtil.log("Got exception while creating robot: " + privilegedActionException.getCause());
            return null;
        }
    }

    private static int transformY(Component component, int y) {
        return component.getHeight() - 1 - y;
    }

    private static Point getPointerLocation(Component component) {
        try {
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (graphicsConfiguration != null) {
                PointerInfo pointerInfo = AccessController.doPrivileged(new AWTUtil$2());
                GraphicsDevice graphicsDevice = pointerInfo.getDevice();
                if (graphicsDevice == graphicsConfiguration.getDevice()) {
                    return pointerInfo.getLocation();
                }
                return null;
            }
        }
        catch (Exception exception) {
            LWJGLUtil.log("Failed to query pointer location: " + exception.getCause());
        }
        return null;
    }

    public static Point getCursorPosition(Component component) {
        try {
            Point point = AWTUtil.getPointerLocation(component);
            if (point != null) {
                Point point2 = component.getLocationOnScreen();
                point.translate(-point2.x, -point2.y);
                point.move(point.x, AWTUtil.transformY(component, point.y));
                return point;
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            LWJGLUtil.log("Failed to set cursor position: " + illegalComponentStateException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LWJGLUtil.log("Failed to query cursor position: " + noClassDefFoundError);
        }
        return null;
    }

    public static void setCursorPosition(Component component, Robot robot, int x, int y) {
        if (robot != null) {
            try {
                Point point = component.getLocationOnScreen();
                int n = point.x + x;
                int n2 = point.y + AWTUtil.transformY(component, y);
                robot.mouseMove(n, n2);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                LWJGLUtil.log("Failed to set cursor position: " + illegalComponentStateException);
            }
        }
    }

    public static int getMinCursorSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(0, 0);
        return Math.max(dimension.width, dimension.height);
    }

    public static int getMaxCursorSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(10000, 10000);
        return Math.min(dimension.width, dimension.height);
    }

    public static Cursor createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        int[] nArray = new int[images.remaining()];
        int n = images.position();
        images.get(nArray);
        images.position(n);
        bufferedImage.setRGB(0, 0, width, height, nArray, 0, width);
        return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(xHotspot, yHotspot), "LWJGL Custom cursor");
    }
}

