/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

final class CallbackUtil {
    private static final Map<ContextCapabilities, Long> contextUserParamsARB = new HashMap<ContextCapabilities, Long>();
    private static final Map<ContextCapabilities, Long> contextUserParamsAMD = new HashMap<ContextCapabilities, Long>();
    private static final Map<ContextCapabilities, Long> contextUserParamsKHR = new HashMap<ContextCapabilities, Long>();

    private CallbackUtil() {
    }

    static long createGlobalRef(Object obj) {
        return obj == null ? 0L : CallbackUtil.ncreateGlobalRef(obj);
    }

    private static native long ncreateGlobalRef(Object var0);

    private static native void deleteGlobalRef(long var0);

    private static void registerContextCallback(long userParam, Map<ContextCapabilities, Long> contextUserData) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        if (contextCapabilities == null) {
            CallbackUtil.deleteGlobalRef(userParam);
            throw new IllegalStateException("No context is current.");
        }
        Long l = contextUserData.remove(contextCapabilities);
        if (l != null) {
            CallbackUtil.deleteGlobalRef(l);
        }
        if (userParam != 0L) {
            contextUserData.put(contextCapabilities, userParam);
        }
    }

    static void unregisterCallbacks(Object context) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities(context);
        Long l = contextUserParamsARB.remove(contextCapabilities);
        if (l != null) {
            CallbackUtil.deleteGlobalRef(l);
        }
        if ((l = contextUserParamsAMD.remove(contextCapabilities)) != null) {
            CallbackUtil.deleteGlobalRef(l);
        }
        if ((l = contextUserParamsKHR.remove(contextCapabilities)) != null) {
            CallbackUtil.deleteGlobalRef(l);
        }
    }

    static native long getDebugOutputCallbackARB();

    static void registerContextCallbackARB(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsARB);
    }

    static native long getDebugOutputCallbackAMD();

    static void registerContextCallbackAMD(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsAMD);
    }

    static native long getDebugCallbackKHR();

    static void registerContextCallbackKHR(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsKHR);
    }
}

