/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextAttribsImplementation;
import org.lwjgl.opengl.LinuxContextAttribs;
import org.lwjgl.opengl.WindowsContextAttribs;

public final class ContextAttribs {
    private static final int CONTEXT_ES2_PROFILE_BIT_EXT = 4;
    private static final int CONTEXT_ROBUST_ACCESS_BIT_ARB = 4;
    private static final int CONTEXT_RESET_NOTIFICATION_STRATEGY_ARB = 33366;
    private static final int NO_RESET_NOTIFICATION_ARB = 33377;
    private static final int LOSE_CONTEXT_ON_RESET_ARB = 33362;
    private static final int CONTEXT_RESET_ISOLATION_BIT_ARB = 8;
    private int majorVersion;
    private int minorVersion;
    private int layerPlane;
    private boolean debug;
    private boolean forwardCompatible;
    private boolean robustAccess;
    private boolean profileCore;
    private boolean profileCompatibility;
    private boolean profileES;
    private boolean loseContextOnReset;
    private boolean contextResetIsolation;

    public ContextAttribs() {
        this(1, 0);
    }

    public ContextAttribs(int majorVersion, int minorVersion) {
        if (majorVersion < 0 || 4 < majorVersion || minorVersion < 0 || majorVersion == 4 && 4 < minorVersion || majorVersion == 3 && 3 < minorVersion || majorVersion == 2 && 1 < minorVersion || majorVersion == 1 && 5 < minorVersion) {
            throw new IllegalArgumentException("Invalid OpenGL version specified: " + majorVersion + '.' + minorVersion);
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    private ContextAttribs(ContextAttribs attribs) {
        this.majorVersion = attribs.majorVersion;
        this.minorVersion = attribs.minorVersion;
        this.layerPlane = attribs.layerPlane;
        this.debug = attribs.debug;
        this.forwardCompatible = attribs.forwardCompatible;
        this.robustAccess = attribs.robustAccess;
        this.profileCore = attribs.profileCore;
        this.profileCompatibility = attribs.profileCompatibility;
        this.profileES = attribs.profileES;
        this.loseContextOnReset = attribs.loseContextOnReset;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getLayerPlane() {
        return this.layerPlane;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isForwardCompatible() {
        return this.forwardCompatible;
    }

    public boolean isProfileCore() {
        return this.profileCore;
    }

    public boolean isProfileCompatibility() {
        return this.profileCompatibility;
    }

    public boolean isProfileES() {
        return this.profileES;
    }

    public ContextAttribs withLayer(int layerPlane) {
        if (layerPlane < 0) {
            throw new IllegalArgumentException("Invalid layer plane specified: " + layerPlane);
        }
        if (layerPlane == this.layerPlane) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.layerPlane = layerPlane;
        return contextAttribs;
    }

    public ContextAttribs withDebug(boolean debug) {
        if (debug == this.debug) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.debug = debug;
        return contextAttribs;
    }

    public ContextAttribs withForwardCompatible(boolean forwardCompatible) {
        if (forwardCompatible == this.forwardCompatible) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.forwardCompatible = forwardCompatible;
        return contextAttribs;
    }

    public ContextAttribs withProfileCore(boolean profileCore) {
        if (this.majorVersion < 3 || this.majorVersion == 3 && this.minorVersion < 2) {
            throw new IllegalArgumentException("Profiles are only supported on OpenGL version 3.2 or higher.");
        }
        if (profileCore == this.profileCore) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.profileCore = profileCore;
        if (profileCore) {
            contextAttribs.profileCompatibility = false;
        }
        return contextAttribs;
    }

    public ContextAttribs withProfileCompatibility(boolean profileCompatibility) {
        if (this.majorVersion < 3 || this.majorVersion == 3 && this.minorVersion < 2) {
            throw new IllegalArgumentException("Profiles are only supported on OpenGL version 3.2 or higher.");
        }
        if (profileCompatibility == this.profileCompatibility) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.profileCompatibility = profileCompatibility;
        if (profileCompatibility) {
            contextAttribs.profileCore = false;
        }
        return contextAttribs;
    }

    public ContextAttribs withProfileES(boolean profileES) {
        if (this.majorVersion != 2 || this.minorVersion != 0) {
            throw new IllegalArgumentException("The OpenGL ES profiles is only supported for OpenGL version 2.0.");
        }
        if (profileES == this.profileES) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.profileES = profileES;
        return contextAttribs;
    }

    public ContextAttribs withLoseContextOnReset(boolean loseContextOnReset) {
        if (loseContextOnReset == this.loseContextOnReset) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.loseContextOnReset = loseContextOnReset;
        return contextAttribs;
    }

    public ContextAttribs withContextResetIsolation(boolean contextResetIsolation) {
        if (contextResetIsolation == this.contextResetIsolation) {
            return this;
        }
        ContextAttribs contextAttribs = new ContextAttribs(this);
        contextAttribs.contextResetIsolation = contextResetIsolation;
        return contextAttribs;
    }

    private static ContextAttribsImplementation getImplementation() {
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                return new LinuxContextAttribs();
            }
            case 3: {
                return new WindowsContextAttribs();
            }
        }
        throw new IllegalStateException("Unsupported platform");
    }

    IntBuffer getAttribList() {
        if (LWJGLUtil.getPlatform() == 2) {
            return null;
        }
        ContextAttribsImplementation contextAttribsImplementation = ContextAttribs.getImplementation();
        int n = 0;
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            n += 2;
        }
        if (0 < this.layerPlane) {
            ++n;
        }
        int n2 = 0;
        if (this.debug) {
            n2 |= contextAttribsImplementation.getDebugBit();
        }
        if (this.forwardCompatible) {
            n2 |= contextAttribsImplementation.getForwardCompatibleBit();
        }
        if (this.robustAccess) {
            n2 |= 4;
        }
        if (this.contextResetIsolation) {
            n2 |= 8;
        }
        if (0 < n2) {
            ++n;
        }
        int n3 = 0;
        if (this.profileCore) {
            n3 |= contextAttribsImplementation.getProfileCoreBit();
        } else if (this.profileCompatibility) {
            n3 |= contextAttribsImplementation.getProfileCompatibilityBit();
        } else if (this.profileES) {
            n3 |= 4;
        }
        if (0 < n3) {
            ++n;
        }
        if (this.loseContextOnReset) {
            ++n;
        }
        if (n == 0) {
            return null;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n * 2 + 1);
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            intBuffer.put(contextAttribsImplementation.getMajorVersionAttrib()).put(this.majorVersion);
            intBuffer.put(contextAttribsImplementation.getMinorVersionAttrib()).put(this.minorVersion);
        }
        if (0 < this.layerPlane) {
            intBuffer.put(contextAttribsImplementation.getLayerPlaneAttrib()).put(this.layerPlane);
        }
        if (0 < n2) {
            intBuffer.put(contextAttribsImplementation.getFlagsAttrib()).put(n2);
        }
        if (0 < n3) {
            intBuffer.put(contextAttribsImplementation.getProfileMaskAttrib()).put(n3);
        }
        if (this.loseContextOnReset) {
            intBuffer.put(33366).put(33362);
        }
        intBuffer.put(0);
        intBuffer.rewind();
        return intBuffer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("ContextAttribs:");
        stringBuilder.append(" Version=").append(this.majorVersion).append('.').append(this.minorVersion);
        stringBuilder.append(" - Layer=").append(this.layerPlane);
        stringBuilder.append(" - Debug=").append(this.debug);
        stringBuilder.append(" - ForwardCompatible=").append(this.forwardCompatible);
        stringBuilder.append(" - RobustAccess=").append(this.robustAccess);
        if (this.robustAccess) {
            stringBuilder.append(" (").append(this.loseContextOnReset ? "LOSE_CONTEXT_ON_RESET" : "NO_RESET_NOTIFICATION");
        }
        stringBuilder.append(" - Profile=");
        if (this.profileCore) {
            stringBuilder.append("Core");
        } else if (this.profileCompatibility) {
            stringBuilder.append("Compatibility");
        } else {
            stringBuilder.append("None");
        }
        return stringBuilder.toString();
    }
}

