/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class EXTDrawBuffers2 {
    private EXTDrawBuffers2() {
    }

    public static void glColorMaskIndexedEXT(int buf, boolean r, boolean g, boolean b, boolean a) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glColorMaskIndexedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDrawBuffers2.nglColorMaskIndexedEXT(buf, r, g, b, a, l);
    }

    static native void nglColorMaskIndexedEXT(int var0, boolean var1, boolean var2, boolean var3, boolean var4, long var5);

    public static void glGetBooleanIndexedEXT(int value, int index, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBooleanIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(data, 4);
        EXTDrawBuffers2.nglGetBooleanIndexedvEXT(value, index, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetBooleanIndexedvEXT(int var0, int var1, long var2, long var4);

    public static boolean glGetBooleanIndexedEXT(int value, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBooleanIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, 1);
        EXTDrawBuffers2.nglGetBooleanIndexedvEXT(value, index, MemoryUtil.getAddress(byteBuffer), l);
        return byteBuffer.get(0) == 1;
    }

    public static void glGetIntegerIndexedEXT(int value, int index, IntBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetIntegerIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(data, 4);
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(value, index, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetIntegerIndexedvEXT(int var0, int var1, long var2, long var4);

    public static int glGetIntegerIndexedEXT(int value, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetIntegerIndexedvEXT;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(value, index, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glEnableIndexedEXT(int target, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEnableIndexedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDrawBuffers2.nglEnableIndexedEXT(target, index, l);
    }

    static native void nglEnableIndexedEXT(int var0, int var1, long var2);

    public static void glDisableIndexedEXT(int target, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDisableIndexedEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTDrawBuffers2.nglDisableIndexedEXT(target, index, l);
    }

    static native void nglDisableIndexedEXT(int var0, int var1, long var2);

    public static boolean glIsEnabledIndexedEXT(int target, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsEnabledIndexedEXT;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = EXTDrawBuffers2.nglIsEnabledIndexedEXT(target, index, l);
        return bl;
    }

    static native boolean nglIsEnabledIndexedEXT(int var0, int var1, long var2);
}

