/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class EXTTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_EXT = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_EXT = 35980;
    public static final int GL_SEPARATE_ATTRIBS_EXT = 35981;
    public static final int GL_PRIMITIVES_GENERATED_EXT = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 35976;
    public static final int GL_RASTERIZER_DISCARD_EXT = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 35967;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 35958;

    private EXTTransformFeedback() {
    }

    public static void glBindBufferRangeEXT(int target, int index, int buffer, long offset, long size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferRangeEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTTransformFeedback.nglBindBufferRangeEXT(target, index, buffer, offset, size, l);
    }

    static native void nglBindBufferRangeEXT(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glBindBufferOffsetEXT(int target, int index, int buffer, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferOffsetEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTTransformFeedback.nglBindBufferOffsetEXT(target, index, buffer, offset, l);
    }

    static native void nglBindBufferOffsetEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glBindBufferBaseEXT(int target, int index, int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferBaseEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTTransformFeedback.nglBindBufferBaseEXT(target, index, buffer, l);
    }

    static native void nglBindBufferBaseEXT(int var0, int var1, int var2, long var3);

    public static void glBeginTransformFeedbackEXT(int primitiveMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBeginTransformFeedbackEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTTransformFeedback.nglBeginTransformFeedbackEXT(primitiveMode, l);
    }

    static native void nglBeginTransformFeedbackEXT(int var0, long var1);

    public static void glEndTransformFeedbackEXT() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEndTransformFeedbackEXT;
        BufferChecks.checkFunctionAddress(l);
        EXTTransformFeedback.nglEndTransformFeedbackEXT(l);
    }

    static native void nglEndTransformFeedbackEXT(long var0);

    public static void glTransformFeedbackVaryingsEXT(int program, int count, ByteBuffer varyings, int bufferMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTransformFeedbackVaryingsEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(varyings);
        BufferChecks.checkNullTerminated(varyings, count);
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, count, MemoryUtil.getAddress(varyings), bufferMode, l);
    }

    static native void nglTransformFeedbackVaryingsEXT(int var0, int var1, long var2, int var4, long var5);

    public static void glTransformFeedbackVaryingsEXT(int program, CharSequence[] varyings, int bufferMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTransformFeedbackVaryingsEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkArray(varyings);
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, varyings.length, APIUtil.getBufferNT(contextCapabilities, varyings), bufferMode, l);
    }

    public static void glGetTransformFeedbackVaryingEXT(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTransformFeedbackVaryingEXT;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetTransformFeedbackVaryingEXT(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTransformFeedbackVaryingEXT;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufSize);
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }
}

