/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.opengl.FastIntMap$Entry;
import org.lwjgl.opengl.FastIntMap$EntryIterator;

final class FastIntMap<V>
implements Iterable<FastIntMap$Entry<V>> {
    private FastIntMap$Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    FastIntMap() {
        this(16, 0.75f);
    }

    FastIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    FastIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new FastIntMap$Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private int index(int key) {
        return FastIntMap.index(key, this.mask);
    }

    private static int index(int key, int mask) {
        return key & mask;
    }

    public V put(int key, V value) {
        FastIntMap$Entry[] fastIntMap$EntryArray = this.table;
        int n = this.index(key);
        FastIntMap$Entry fastIntMap$Entry = fastIntMap$EntryArray[n];
        while (fastIntMap$Entry != null) {
            if (fastIntMap$Entry.key == key) {
                Object t = fastIntMap$Entry.value;
                fastIntMap$Entry.value = value;
                return (V)t;
            }
            fastIntMap$Entry = fastIntMap$Entry.next;
        }
        fastIntMap$EntryArray[n] = new FastIntMap$Entry<V>(key, value, fastIntMap$EntryArray[n]);
        if (this.size++ >= this.threshold) {
            this.rehash(fastIntMap$EntryArray);
        }
        return null;
    }

    private void rehash(FastIntMap$Entry<V>[] table) {
        int n = 2 * this.capacity;
        int n2 = n - 1;
        FastIntMap$Entry[] fastIntMap$EntryArray = new FastIntMap$Entry[n];
        for (int i = 0; i < table.length; ++i) {
            FastIntMap$Entry fastIntMap$Entry;
            FastIntMap$Entry<Object> fastIntMap$Entry2 = table[i];
            if (fastIntMap$Entry2 == null) continue;
            do {
                fastIntMap$Entry = fastIntMap$Entry2.next;
                int n3 = FastIntMap.index(fastIntMap$Entry2.key, n2);
                fastIntMap$Entry2.next = fastIntMap$EntryArray[n3];
                fastIntMap$EntryArray[n3] = fastIntMap$Entry2;
            } while ((fastIntMap$Entry2 = fastIntMap$Entry) != null);
        }
        this.table = fastIntMap$EntryArray;
        this.capacity = n;
        this.mask = n2;
        this.threshold *= 2;
    }

    public V get(int key) {
        int n = this.index(key);
        FastIntMap$Entry fastIntMap$Entry = this.table[n];
        while (fastIntMap$Entry != null) {
            if (fastIntMap$Entry.key == key) {
                return (V)fastIntMap$Entry.value;
            }
            fastIntMap$Entry = fastIntMap$Entry.next;
        }
        return null;
    }

    public boolean containsValue(Object value) {
        FastIntMap$Entry[] fastIntMap$EntryArray = this.table;
        for (int i = fastIntMap$EntryArray.length - 1; i >= 0; --i) {
            FastIntMap$Entry fastIntMap$Entry = fastIntMap$EntryArray[i];
            while (fastIntMap$Entry != null) {
                if (fastIntMap$Entry.value.equals(value)) {
                    return true;
                }
                fastIntMap$Entry = fastIntMap$Entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        int n = this.index(key);
        FastIntMap$Entry fastIntMap$Entry = this.table[n];
        while (fastIntMap$Entry != null) {
            if (fastIntMap$Entry.key == key) {
                return true;
            }
            fastIntMap$Entry = fastIntMap$Entry.next;
        }
        return false;
    }

    public V remove(int key) {
        FastIntMap$Entry fastIntMap$Entry;
        int n = this.index(key);
        FastIntMap$Entry fastIntMap$Entry2 = fastIntMap$Entry = this.table[n];
        while (fastIntMap$Entry2 != null) {
            FastIntMap$Entry fastIntMap$Entry3 = fastIntMap$Entry2.next;
            if (fastIntMap$Entry2.key == key) {
                --this.size;
                if (fastIntMap$Entry == fastIntMap$Entry2) {
                    this.table[n] = fastIntMap$Entry3;
                } else {
                    fastIntMap$Entry.next = fastIntMap$Entry3;
                }
                return (V)fastIntMap$Entry2.value;
            }
            fastIntMap$Entry = fastIntMap$Entry2;
            fastIntMap$Entry2 = fastIntMap$Entry3;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        FastIntMap$Entry[] fastIntMap$EntryArray = this.table;
        for (int i = fastIntMap$EntryArray.length - 1; i >= 0; --i) {
            fastIntMap$EntryArray[i] = null;
        }
        this.size = 0;
    }

    public FastIntMap$EntryIterator iterator() {
        return new FastIntMap$EntryIterator(this);
    }

    static /* synthetic */ FastIntMap$Entry[] access$000(FastIntMap x0) {
        return x0.table;
    }
}

