/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL14 {
    public static final int GL_GENERATE_MIPMAP = 33169;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_DEPTH_COMPONENT32 = 33191;
    public static final int GL_TEXTURE_DEPTH_SIZE = 34890;
    public static final int GL_DEPTH_TEXTURE_MODE = 34891;
    public static final int GL_TEXTURE_COMPARE_MODE = 34892;
    public static final int GL_TEXTURE_COMPARE_FUNC = 34893;
    public static final int GL_COMPARE_R_TO_TEXTURE = 34894;
    public static final int GL_FOG_COORDINATE_SOURCE = 33872;
    public static final int GL_FOG_COORDINATE = 33873;
    public static final int GL_FRAGMENT_DEPTH = 33874;
    public static final int GL_CURRENT_FOG_COORDINATE = 33875;
    public static final int GL_FOG_COORDINATE_ARRAY_TYPE = 33876;
    public static final int GL_FOG_COORDINATE_ARRAY_STRIDE = 33877;
    public static final int GL_FOG_COORDINATE_ARRAY_POINTER = 33878;
    public static final int GL_FOG_COORDINATE_ARRAY = 33879;
    public static final int GL_POINT_SIZE_MIN = 33062;
    public static final int GL_POINT_SIZE_MAX = 33063;
    public static final int GL_POINT_FADE_THRESHOLD_SIZE = 33064;
    public static final int GL_POINT_DISTANCE_ATTENUATION = 33065;
    public static final int GL_COLOR_SUM = 33880;
    public static final int GL_CURRENT_SECONDARY_COLOR = 33881;
    public static final int GL_SECONDARY_COLOR_ARRAY_SIZE = 33882;
    public static final int GL_SECONDARY_COLOR_ARRAY_TYPE = 33883;
    public static final int GL_SECONDARY_COLOR_ARRAY_STRIDE = 33884;
    public static final int GL_SECONDARY_COLOR_ARRAY_POINTER = 33885;
    public static final int GL_SECONDARY_COLOR_ARRAY = 33886;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_TEXTURE_FILTER_CONTROL = 34048;
    public static final int GL_TEXTURE_LOD_BIAS = 34049;
    public static final int GL_MAX_TEXTURE_LOD_BIAS = 34045;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_MIN = 32775;
    public static final int GL_MAX = 32776;

    private GL14() {
    }

    public static void glBlendEquation(int mode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendEquation;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglBlendEquation(mode, l);
    }

    static native void nglBlendEquation(int var0, long var1);

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendColor;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglBlendColor(red, green, blue, alpha, l);
    }

    static native void nglBlendColor(float var0, float var1, float var2, float var3, long var4);

    public static void glFogCoordf(float coord) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFogCoordf;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglFogCoordf(coord, l);
    }

    static native void nglFogCoordf(float var0, long var1);

    public static void glFogCoordd(double coord) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFogCoordd;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglFogCoordd(coord, l);
    }

    static native void nglFogCoordd(double var0, long var2);

    public static void glFogCoordPointer(int stride, DoubleBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFogCoordPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).GL14_glFogCoordPointer_data = data;
        }
        GL14.nglFogCoordPointer(5130, stride, MemoryUtil.getAddress(data), l);
    }

    public static void glFogCoordPointer(int stride, FloatBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFogCoordPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).GL14_glFogCoordPointer_data = data;
        }
        GL14.nglFogCoordPointer(5126, stride, MemoryUtil.getAddress(data), l);
    }

    static native void nglFogCoordPointer(int var0, int var1, long var2, long var4);

    public static void glFogCoordPointer(int type, int stride, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFogCoordPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        GL14.nglFogCoordPointerBO(type, stride, data_buffer_offset, l);
    }

    static native void nglFogCoordPointerBO(int var0, int var1, long var2, long var4);

    public static void glMultiDrawArrays(int mode, IntBuffer piFirst, IntBuffer piCount) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMultiDrawArrays;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(piFirst);
        BufferChecks.checkBuffer(piCount, piFirst.remaining());
        GL14.nglMultiDrawArrays(mode, MemoryUtil.getAddress(piFirst), MemoryUtil.getAddress(piCount), piFirst.remaining(), l);
    }

    static native void nglMultiDrawArrays(int var0, long var1, long var3, int var5, long var6);

    public static void glPointParameteri(int pname, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPointParameteri;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglPointParameteri(pname, param, l);
    }

    static native void nglPointParameteri(int var0, int var1, long var2);

    public static void glPointParameterf(int pname, float param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPointParameterf;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglPointParameterf(pname, param, l);
    }

    static native void nglPointParameterf(int var0, float var1, long var2);

    public static void glPointParameter(int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPointParameteriv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        GL14.nglPointParameteriv(pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglPointParameteriv(int var0, long var1, long var3);

    public static void glPointParameter(int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPointParameterfv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        GL14.nglPointParameterfv(pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglPointParameterfv(int var0, long var1, long var3);

    public static void glSecondaryColor3b(byte red, byte green, byte blue) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColor3b;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglSecondaryColor3b(red, green, blue, l);
    }

    static native void nglSecondaryColor3b(byte var0, byte var1, byte var2, long var3);

    public static void glSecondaryColor3f(float red, float green, float blue) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColor3f;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglSecondaryColor3f(red, green, blue, l);
    }

    static native void nglSecondaryColor3f(float var0, float var1, float var2, long var3);

    public static void glSecondaryColor3d(double red, double green, double blue) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColor3d;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglSecondaryColor3d(red, green, blue, l);
    }

    static native void nglSecondaryColor3d(double var0, double var2, double var4, long var6);

    public static void glSecondaryColor3ub(byte red, byte green, byte blue) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColor3ub;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglSecondaryColor3ub(red, green, blue, l);
    }

    static native void nglSecondaryColor3ub(byte var0, byte var1, byte var2, long var3);

    public static void glSecondaryColorPointer(int size, int stride, DoubleBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColorPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        GL14.nglSecondaryColorPointer(size, 5130, stride, MemoryUtil.getAddress(data), l);
    }

    public static void glSecondaryColorPointer(int size, int stride, FloatBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColorPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        GL14.nglSecondaryColorPointer(size, 5126, stride, MemoryUtil.getAddress(data), l);
    }

    public static void glSecondaryColorPointer(int size, boolean unsigned, int stride, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColorPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(data);
        GL14.nglSecondaryColorPointer(size, unsigned ? 5121 : 5120, stride, MemoryUtil.getAddress(data), l);
    }

    static native void nglSecondaryColorPointer(int var0, int var1, int var2, long var3, long var5);

    public static void glSecondaryColorPointer(int size, int type, int stride, long data_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSecondaryColorPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        GL14.nglSecondaryColorPointerBO(size, type, stride, data_buffer_offset, l);
    }

    static native void nglSecondaryColorPointerBO(int var0, int var1, int var2, long var3, long var5);

    public static void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendFuncSeparate;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha, l);
    }

    static native void nglBlendFuncSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glWindowPos2f(float x, float y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWindowPos2f;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglWindowPos2f(x, y, l);
    }

    static native void nglWindowPos2f(float var0, float var1, long var2);

    public static void glWindowPos2d(double x, double y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWindowPos2d;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglWindowPos2d(x, y, l);
    }

    static native void nglWindowPos2d(double var0, double var2, long var4);

    public static void glWindowPos2i(int x, int y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWindowPos2i;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglWindowPos2i(x, y, l);
    }

    static native void nglWindowPos2i(int var0, int var1, long var2);

    public static void glWindowPos3f(float x, float y, float z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWindowPos3f;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglWindowPos3f(x, y, z, l);
    }

    static native void nglWindowPos3f(float var0, float var1, float var2, long var3);

    public static void glWindowPos3d(double x, double y, double z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWindowPos3d;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglWindowPos3d(x, y, z, l);
    }

    static native void nglWindowPos3d(double var0, double var2, double var4, long var6);

    public static void glWindowPos3i(int x, int y, int z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWindowPos3i;
        BufferChecks.checkFunctionAddress(l);
        GL14.nglWindowPos3i(x, y, z, l);
    }

    static native void nglWindowPos3i(int var0, int var1, int var2, long var3);
}

