/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;

public final class GL32 {
    public static final int GL_CONTEXT_PROFILE_MASK = 37158;
    public static final int GL_CONTEXT_CORE_PROFILE_BIT = 1;
    public static final int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_PROVOKING_VERTEX = 36431;
    public static final int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 36428;
    public static final int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public static final int GL_DEPTH_CLAMP = 34383;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_VERTICES_OUT = 36314;
    public static final int GL_GEOMETRY_INPUT_TYPE = 36315;
    public static final int GL_GEOMETRY_OUTPUT_TYPE = 36316;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_VARYING_COMPONENTS = 35659;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public static final int GL_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    private GL32() {
    }

    public static void glGetBufferParameter(int target, int pname, LongBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferParameteri64v;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetBufferParameteri64v(int var0, int var1, long var2, long var4);

    @Deprecated
    public static long glGetBufferParameter(int target, int pname) {
        return GL32.glGetBufferParameteri64(target, pname);
    }

    public static long glGetBufferParameteri64(int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferParameteri64v;
        BufferChecks.checkFunctionAddress(l);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.getAddress(longBuffer), l);
        return longBuffer.get(0);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.getAddress(indices), basevertex, l);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.getAddress(indices), basevertex, l);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.getAddress(indices), basevertex, l);
    }

    static native void nglDrawElementsBaseVertex(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glDrawElementsBaseVertex(int mode, int indices_count, int type, long indices_buffer_offset, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOenabled(contextCapabilities);
        GL32.nglDrawElementsBaseVertexBO(mode, indices_count, type, indices_buffer_offset, basevertex, l);
    }

    static native void nglDrawElementsBaseVertexBO(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.getAddress(indices), basevertex, l);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.getAddress(indices), basevertex, l);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.getAddress(indices), basevertex, l);
    }

    static native void nglDrawRangeElementsBaseVertex(int var0, int var1, int var2, int var3, int var4, long var5, int var7, long var8);

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int indices_count, int type, long indices_buffer_offset, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawRangeElementsBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOenabled(contextCapabilities);
        GL32.nglDrawRangeElementsBaseVertexBO(mode, start, end, indices_count, type, indices_buffer_offset, basevertex, l);
    }

    static native void nglDrawRangeElementsBaseVertexBO(int var0, int var1, int var2, int var3, int var4, long var5, int var7, long var8);

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int primcount, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.getAddress(indices), primcount, basevertex, l);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int primcount, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.getAddress(indices), primcount, basevertex, l);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int primcount, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(indices);
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.getAddress(indices), primcount, basevertex, l);
    }

    static native void nglDrawElementsInstancedBaseVertex(int var0, int var1, int var2, long var3, int var5, int var6, long var7);

    public static void glDrawElementsInstancedBaseVertex(int mode, int indices_count, int type, long indices_buffer_offset, int primcount, int basevertex) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsInstancedBaseVertex;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureElementVBOenabled(contextCapabilities);
        GL32.nglDrawElementsInstancedBaseVertexBO(mode, indices_count, type, indices_buffer_offset, primcount, basevertex, l);
    }

    static native void nglDrawElementsInstancedBaseVertexBO(int var0, int var1, int var2, long var3, int var5, int var6, long var7);

    public static void glProvokingVertex(int mode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProvokingVertex;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglProvokingVertex(mode, l);
    }

    static native void nglProvokingVertex(int var0, long var1);

    public static void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTexImage2DMultisample;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglTexImage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations, l);
    }

    static native void nglTexImage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    public static void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTexImage3DMultisample;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglTexImage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations, l);
    }

    static native void nglTexImage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, long var7);

    public static void glGetMultisample(int pname, int index, FloatBuffer val2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetMultisamplefv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(val2, 2);
        GL32.nglGetMultisamplefv(pname, index, MemoryUtil.getAddress(val2), l);
    }

    static native void nglGetMultisamplefv(int var0, int var1, long var2, long var4);

    public static void glSampleMaski(int index, int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glSampleMaski;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglSampleMaski(index, mask, l);
    }

    static native void nglSampleMaski(int var0, int var1, long var2);

    public static void glFramebufferTexture(int target, int attachment, int texture, int level) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFramebufferTexture;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglFramebufferTexture(target, attachment, texture, level, l);
    }

    static native void nglFramebufferTexture(int var0, int var1, int var2, int var3, long var4);

    public static GLSync glFenceSync(int condition, int flags) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glFenceSync;
        BufferChecks.checkFunctionAddress(l);
        GLSync gLSync = new GLSync(GL32.nglFenceSync(condition, flags, l));
        return gLSync;
    }

    static native long nglFenceSync(int var0, int var1, long var2);

    public static boolean glIsSync(GLSync sync) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsSync;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = GL32.nglIsSync(sync.getPointer(), l);
        return bl;
    }

    static native boolean nglIsSync(long var0, long var2);

    public static void glDeleteSync(GLSync sync) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteSync;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglDeleteSync(sync.getPointer(), l);
    }

    static native void nglDeleteSync(long var0, long var2);

    public static int glClientWaitSync(GLSync sync, int flags, long timeout) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glClientWaitSync;
        BufferChecks.checkFunctionAddress(l);
        int n = GL32.nglClientWaitSync(sync.getPointer(), flags, timeout, l);
        return n;
    }

    static native int nglClientWaitSync(long var0, int var2, long var3, long var5);

    public static void glWaitSync(GLSync sync, int flags, long timeout) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWaitSync;
        BufferChecks.checkFunctionAddress(l);
        GL32.nglWaitSync(sync.getPointer(), flags, timeout, l);
    }

    static native void nglWaitSync(long var0, int var2, long var3, long var5);

    public static void glGetInteger64(int pname, LongBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetInteger64v;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(data, 1);
        GL32.nglGetInteger64v(pname, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetInteger64v(int var0, long var1, long var3);

    public static long glGetInteger64(int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetInteger64v;
        BufferChecks.checkFunctionAddress(l);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL32.nglGetInteger64v(pname, MemoryUtil.getAddress(longBuffer), l);
        return longBuffer.get(0);
    }

    public static void glGetInteger64(int value, int index, LongBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetInteger64i_v;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(data, 4);
        GL32.nglGetInteger64i_v(value, index, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetInteger64i_v(int var0, int var1, long var2, long var4);

    public static long glGetInteger64(int value, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetInteger64i_v;
        BufferChecks.checkFunctionAddress(l);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        GL32.nglGetInteger64i_v(value, index, MemoryUtil.getAddress(longBuffer), l);
        return longBuffer.get(0);
    }

    public static void glGetSync(GLSync sync, int pname, IntBuffer length, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetSynciv;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(values);
        GL32.nglGetSynciv(sync.getPointer(), pname, values.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(values), l);
    }

    static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6, long var8);

    @Deprecated
    public static int glGetSync(GLSync sync, int pname) {
        return GL32.glGetSynci(sync, pname);
    }

    public static int glGetSynci(GLSync sync, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetSynciv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL32.nglGetSynciv(sync.getPointer(), pname, 1, 0L, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }
}

