/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class GL40 {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_GEOMETRY_SHADER_INVOCATIONS = 34943;
    public static final int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 36442;
    public static final int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 36443;
    public static final int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 36444;
    public static final int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 36445;
    public static final int GL_MAX_VERTEX_STREAMS = 36465;
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;
    public static final int GL_SAMPLE_SHADING = 35894;
    public static final int GL_MIN_SAMPLE_SHADING_VALUE = 35895;
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_PATCHES = 14;
    public static final int GL_PATCH_VERTICES = 36466;
    public static final int GL_PATCH_DEFAULT_INNER_LEVEL = 36467;
    public static final int GL_PATCH_DEFAULT_OUTER_LEVEL = 36468;
    public static final int GL_TESS_CONTROL_OUTPUT_VERTICES = 36469;
    public static final int GL_TESS_GEN_MODE = 36470;
    public static final int GL_TESS_GEN_SPACING = 36471;
    public static final int GL_TESS_GEN_VERTEX_ORDER = 36472;
    public static final int GL_TESS_GEN_POINT_MODE = 36473;
    public static final int GL_ISOLINES = 36474;
    public static final int GL_FRACTIONAL_ODD = 36475;
    public static final int GL_FRACTIONAL_EVEN = 36476;
    public static final int GL_MAX_PATCH_VERTICES = 36477;
    public static final int GL_MAX_TESS_GEN_LEVEL = 36478;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 36479;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 36480;
    public static final int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 36481;
    public static final int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 36482;
    public static final int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 36483;
    public static final int GL_MAX_TESS_PATCH_COMPONENTS = 36484;
    public static final int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 36485;
    public static final int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 36486;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 36489;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 36490;
    public static final int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 34924;
    public static final int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 34925;
    public static final int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 36382;
    public static final int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 36383;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 34032;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 34033;
    public static final int GL_TESS_EVALUATION_SHADER = 36487;
    public static final int GL_TESS_CONTROL_SHADER = 36488;
    public static final int GL_TEXTURE_CUBE_MAP_ARRAY = 36873;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 36874;
    public static final int GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 36875;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY = 36876;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 36877;
    public static final int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 36878;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 36879;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 36447;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 36767;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 36464;

    private GL40() {
    }

    public static void glBlendEquationi(int buf, int mode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendEquationi;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglBlendEquationi(buf, mode, l);
    }

    static native void nglBlendEquationi(int var0, int var1, long var2);

    public static void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendEquationSeparatei;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglBlendEquationSeparatei(buf, modeRGB, modeAlpha, l);
    }

    static native void nglBlendEquationSeparatei(int var0, int var1, int var2, long var3);

    public static void glBlendFunci(int buf, int src, int dst) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendFunci;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglBlendFunci(buf, src, dst, l);
    }

    static native void nglBlendFunci(int var0, int var1, int var2, long var3);

    public static void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendFuncSeparatei;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglBlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha, l);
    }

    static native void nglBlendFuncSeparatei(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawArraysIndirect;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(indirect, 16);
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.getAddress(indirect), l);
    }

    static native void nglDrawArraysIndirect(int var0, long var1, long var3);

    public static void glDrawArraysIndirect(int mode, long indirect_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawArraysIndirect;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureIndirectBOenabled(contextCapabilities);
        GL40.nglDrawArraysIndirectBO(mode, indirect_buffer_offset, l);
    }

    static native void nglDrawArraysIndirectBO(int var0, long var1, long var3);

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawArraysIndirect;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(indirect, 4);
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.getAddress(indirect), l);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsIndirect;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(indirect, 20);
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.getAddress(indirect), l);
    }

    static native void nglDrawElementsIndirect(int var0, int var1, long var2, long var4);

    public static void glDrawElementsIndirect(int mode, int type, long indirect_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsIndirect;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureIndirectBOenabled(contextCapabilities);
        GL40.nglDrawElementsIndirectBO(mode, type, indirect_buffer_offset, l);
    }

    static native void nglDrawElementsIndirectBO(int var0, int var1, long var2, long var4);

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawElementsIndirect;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureIndirectBOdisabled(contextCapabilities);
        BufferChecks.checkBuffer(indirect, 5);
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.getAddress(indirect), l);
    }

    public static void glUniform1d(int location, double x) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1d;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglUniform1d(location, x, l);
    }

    static native void nglUniform1d(int var0, double var1, long var3);

    public static void glUniform2d(int location, double x, double y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2d;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglUniform2d(location, x, y, l);
    }

    static native void nglUniform2d(int var0, double var1, double var3, long var5);

    public static void glUniform3d(int location, double x, double y, double z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3d;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglUniform3d(location, x, y, z, l);
    }

    static native void nglUniform3d(int var0, double var1, double var3, double var5, long var7);

    public static void glUniform4d(int location, double x, double y, double z, double w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4d;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglUniform4d(location, x, y, z, w, l);
    }

    static native void nglUniform4d(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glUniform1(int location, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniform1dv(location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglUniform1dv(int var0, int var1, long var2, long var4);

    public static void glUniform2(int location, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniform2dv(location, value.remaining() >> 1, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniform2dv(int var0, int var1, long var2, long var4);

    public static void glUniform3(int location, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniform3dv(location, value.remaining() / 3, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniform3dv(int var0, int var1, long var2, long var4);

    public static void glUniform4(int location, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniform4dv(location, value.remaining() >> 2, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniform4dv(int var0, int var1, long var2, long var4);

    public static void glUniformMatrix2(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix2dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix2dv(location, value.remaining() >> 2, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix2dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix3dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix3dv(location, value.remaining() / 9, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix3dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix4dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix4dv(location, value.remaining() >> 4, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix4dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix2x3(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix2x3dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix2x3dv(location, value.remaining() / 6, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix2x3dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix2x4(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix2x4dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix2x4dv(location, value.remaining() >> 3, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix2x4dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3x2(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix3x2dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix3x2dv(location, value.remaining() / 6, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix3x2dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3x4(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix3x4dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix3x4dv(location, value.remaining() / 12, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix3x4dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4x2(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix4x2dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix4x2dv(location, value.remaining() >> 3, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix4x2dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4x3(int location, boolean transpose, DoubleBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix4x3dv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        GL40.nglUniformMatrix4x3dv(location, value.remaining() / 12, transpose, MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformMatrix4x3dv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glGetUniform(int program, int location, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformdv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        GL40.nglGetUniformdv(program, location, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetUniformdv(int var0, int var1, long var2, long var4);

    public static void glMinSampleShading(float value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMinSampleShading;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglMinSampleShading(value, l);
    }

    static native void nglMinSampleShading(float var0, long var1);

    public static int glGetSubroutineUniformLocation(int program, int shadertype, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetSubroutineUniformLocation;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int n = GL40.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.getAddress(name), l);
        return n;
    }

    static native int nglGetSubroutineUniformLocation(int var0, int var1, long var2, long var4);

    public static int glGetSubroutineUniformLocation(int program, int shadertype, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetSubroutineUniformLocation;
        BufferChecks.checkFunctionAddress(l);
        int n = GL40.nglGetSubroutineUniformLocation(program, shadertype, APIUtil.getBufferNT(contextCapabilities, name), l);
        return n;
    }

    public static int glGetSubroutineIndex(int program, int shadertype, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetSubroutineIndex;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int n = GL40.nglGetSubroutineIndex(program, shadertype, MemoryUtil.getAddress(name), l);
        return n;
    }

    static native int nglGetSubroutineIndex(int var0, int var1, long var2, long var4);

    public static int glGetSubroutineIndex(int program, int shadertype, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetSubroutineIndex;
        BufferChecks.checkFunctionAddress(l);
        int n = GL40.nglGetSubroutineIndex(program, shadertype, APIUtil.getBufferNT(contextCapabilities, name), l);
        return n;
    }

    public static void glGetActiveSubroutineUniform(int program, int shadertype, int index, int pname, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveSubroutineUniformiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(values, 1);
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.getAddress(values), l);
    }

    static native void nglGetActiveSubroutineUniformiv(int var0, int var1, int var2, int var3, long var4, long var6);

    @Deprecated
    public static int glGetActiveSubroutineUniform(int program, int shadertype, int index, int pname) {
        return GL40.glGetActiveSubroutineUniformi(program, shadertype, index, pname);
    }

    public static int glGetActiveSubroutineUniformi(int program, int shadertype, int index, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveSubroutineUniformiv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveSubroutineUniformName;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(name);
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetActiveSubroutineUniformName(int var0, int var1, int var2, int var3, long var4, long var6, long var8);

    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveSubroutineUniformName;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufsize);
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveSubroutineName;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(name);
        GL40.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetActiveSubroutineName(int var0, int var1, int var2, int var3, long var4, long var6, long var8);

    public static String glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveSubroutineName;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufsize);
        GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glUniformSubroutinesu(int shadertype, IntBuffer indices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformSubroutinesuiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(indices);
        GL40.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.getAddress(indices), l);
    }

    static native void nglUniformSubroutinesuiv(int var0, int var1, long var2, long var4);

    public static void glGetUniformSubroutineu(int shadertype, int location, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformSubroutineuiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 1);
        GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetUniformSubroutineuiv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetUniformSubroutineu(int shadertype, int location) {
        return GL40.glGetUniformSubroutineui(shadertype, location);
    }

    public static int glGetUniformSubroutineui(int shadertype, int location) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformSubroutineuiv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetProgramStage(int program, int shadertype, int pname, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramStageiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(values, 1);
        GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.getAddress(values), l);
    }

    static native void nglGetProgramStageiv(int var0, int var1, int var2, long var3, long var5);

    @Deprecated
    public static int glGetProgramStage(int program, int shadertype, int pname) {
        return GL40.glGetProgramStagei(program, shadertype, pname);
    }

    public static int glGetProgramStagei(int program, int shadertype, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramStageiv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glPatchParameteri(int pname, int value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPatchParameteri;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglPatchParameteri(pname, value, l);
    }

    static native void nglPatchParameteri(int var0, int var1, long var2);

    public static void glPatchParameter(int pname, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPatchParameterfv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(values, 4);
        GL40.nglPatchParameterfv(pname, MemoryUtil.getAddress(values), l);
    }

    static native void nglPatchParameterfv(int var0, long var1, long var3);

    public static void glBindTransformFeedback(int target, int id) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindTransformFeedback;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglBindTransformFeedback(target, id, l);
    }

    static native void nglBindTransformFeedback(int var0, int var1, long var2);

    public static void glDeleteTransformFeedbacks(IntBuffer ids) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteTransformFeedbacks;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(ids);
        GL40.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.getAddress(ids), l);
    }

    static native void nglDeleteTransformFeedbacks(int var0, long var1, long var3);

    public static void glDeleteTransformFeedbacks(int id) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteTransformFeedbacks;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglDeleteTransformFeedbacks(1, APIUtil.getInt(contextCapabilities, id), l);
    }

    public static void glGenTransformFeedbacks(IntBuffer ids) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenTransformFeedbacks;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(ids);
        GL40.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.getAddress(ids), l);
    }

    static native void nglGenTransformFeedbacks(int var0, long var1, long var3);

    public static int glGenTransformFeedbacks() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenTransformFeedbacks;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL40.nglGenTransformFeedbacks(1, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static boolean glIsTransformFeedback(int id) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsTransformFeedback;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = GL40.nglIsTransformFeedback(id, l);
        return bl;
    }

    static native boolean nglIsTransformFeedback(int var0, long var1);

    public static void glPauseTransformFeedback() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPauseTransformFeedback;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglPauseTransformFeedback(l);
    }

    static native void nglPauseTransformFeedback(long var0);

    public static void glResumeTransformFeedback() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glResumeTransformFeedback;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglResumeTransformFeedback(l);
    }

    static native void nglResumeTransformFeedback(long var0);

    public static void glDrawTransformFeedback(int mode, int id) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawTransformFeedback;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglDrawTransformFeedback(mode, id, l);
    }

    static native void nglDrawTransformFeedback(int var0, int var1, long var2);

    public static void glDrawTransformFeedbackStream(int mode, int id, int stream) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawTransformFeedbackStream;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglDrawTransformFeedbackStream(mode, id, stream, l);
    }

    static native void nglDrawTransformFeedbackStream(int var0, int var1, int var2, long var3);

    public static void glBeginQueryIndexed(int target, int index, int id) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBeginQueryIndexed;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglBeginQueryIndexed(target, index, id, l);
    }

    static native void nglBeginQueryIndexed(int var0, int var1, int var2, long var3);

    public static void glEndQueryIndexed(int target, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEndQueryIndexed;
        BufferChecks.checkFunctionAddress(l);
        GL40.nglEndQueryIndexed(target, index, l);
    }

    static native void nglEndQueryIndexed(int var0, int var1, long var2);

    public static void glGetQueryIndexed(int target, int index, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetQueryIndexediv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 1);
        GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetQueryIndexediv(int var0, int var1, int var2, long var3, long var5);

    @Deprecated
    public static int glGetQueryIndexed(int target, int index, int pname) {
        return GL40.glGetQueryIndexedi(target, index, pname);
    }

    public static int glGetQueryIndexedi(int target, int index, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetQueryIndexediv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }
}

