/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext$1;
import org.lwjgl.opengl.GLContext$2;
import org.lwjgl.opengl.GLContext$CapabilitiesCacheEntry;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;

public final class GLContext {
    private static final ThreadLocal<ContextCapabilities> current_capabilities = new ThreadLocal();
    private static GLContext$CapabilitiesCacheEntry fast_path_cache = new GLContext$CapabilitiesCacheEntry(null);
    private static final ThreadLocal<GLContext$CapabilitiesCacheEntry> thread_cache_entries = new ThreadLocal();
    private static final Map<Object, ContextCapabilities> capability_cache = new WeakHashMap<Object, ContextCapabilities>();
    private static int gl_ref_count;
    private static boolean did_auto_load;

    public static ContextCapabilities getCapabilities() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilitiesImpl();
        if (contextCapabilities == null) {
            throw new RuntimeException("No OpenGL context found in the current thread.");
        }
        return contextCapabilities;
    }

    private static ContextCapabilities getCapabilitiesImpl() {
        GLContext$CapabilitiesCacheEntry gLContext$CapabilitiesCacheEntry = fast_path_cache;
        if (gLContext$CapabilitiesCacheEntry.owner == Thread.currentThread()) {
            return gLContext$CapabilitiesCacheEntry.capabilities;
        }
        return GLContext.getThreadLocalCapabilities();
    }

    static ContextCapabilities getCapabilities(Object context) {
        return capability_cache.get(context);
    }

    private static ContextCapabilities getThreadLocalCapabilities() {
        return current_capabilities.get();
    }

    static void setCapabilities(ContextCapabilities capabilities) {
        current_capabilities.set(capabilities);
        GLContext$CapabilitiesCacheEntry gLContext$CapabilitiesCacheEntry = thread_cache_entries.get();
        if (gLContext$CapabilitiesCacheEntry == null) {
            gLContext$CapabilitiesCacheEntry = new GLContext$CapabilitiesCacheEntry(null);
            thread_cache_entries.set(gLContext$CapabilitiesCacheEntry);
        }
        gLContext$CapabilitiesCacheEntry.owner = Thread.currentThread();
        gLContext$CapabilitiesCacheEntry.capabilities = capabilities;
        fast_path_cache = gLContext$CapabilitiesCacheEntry;
    }

    static long getPlatformSpecificFunctionAddress(String function_prefix, String[] os_prefixes, String[] os_function_prefixes, String function) {
        String string = AccessController.doPrivileged(new GLContext$1());
        for (int i = 0; i < os_prefixes.length; ++i) {
            if (!string.startsWith(os_prefixes[i])) continue;
            String string2 = function.replaceFirst(function_prefix, os_function_prefixes[i]);
            long l = GLContext.getFunctionAddress(string2);
            return l;
        }
        return 0L;
    }

    static long getFunctionAddress(String[] aliases) {
        for (String string : aliases) {
            long l = GLContext.getFunctionAddress(string);
            if (l == 0L) continue;
            return l;
        }
        return 0L;
    }

    static long getFunctionAddress(String name) {
        ByteBuffer byteBuffer = MemoryUtil.encodeASCII(name);
        return GLContext.ngetFunctionAddress(MemoryUtil.getAddress(byteBuffer));
    }

    private static native long ngetFunctionAddress(long var0);

    static int getSupportedExtensions(Set<String> supported_extensions) {
        int n;
        block11: {
            int n2;
            int n3;
            block10: {
                Object object;
                String string = GL11.glGetString(7938);
                if (string == null) {
                    throw new IllegalStateException("glGetString(GL_VERSION) returned null - possibly caused by missing current context.");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                n3 = 0;
                n2 = 0;
                try {
                    n3 = Integer.parseInt(string2);
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    LWJGLUtil.log("The major and/or minor OpenGL version is malformed: " + numberFormatException.getMessage());
                }
                int[][] nArrayArray = new int[][]{{1, 2, 3, 4, 5}, {0, 1}, {0, 1, 2, 3}, {0, 1, 2, 3, 4}};
                for (n = 1; n <= nArrayArray.length; ++n) {
                    object = nArrayArray[n - 1];
                    for (int n4 : object) {
                        if (n >= n3 && (n != n3 || n4 > n2)) continue;
                        supported_extensions.add("OpenGL" + Integer.toString(n) + Integer.toString(n4));
                    }
                }
                n = 0;
                if (n3 >= 3) break block10;
                object = GL11.glGetString(7939);
                if (object == null) {
                    throw new IllegalStateException("glGetString(GL_EXTENSIONS) returned null - is there a context current?");
                }
                Object object2 = new StringTokenizer((String)object);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    supported_extensions.add(((StringTokenizer)object2).nextToken());
                }
                break block11;
            }
            int n5 = GL11.glGetInteger(33309);
            for (int i = 0; i < n5; ++i) {
                supported_extensions.add(GL30.glGetStringi(7939, i));
            }
            if (3 >= n3 && 2 > n2) break block11;
            Util.checkGLError();
            try {
                n = GL11.glGetInteger(37158);
                Util.checkGLError();
            }
            catch (OpenGLException openGLException) {
                LWJGLUtil.log("Failed to retrieve CONTEXT_PROFILE_MASK");
            }
        }
        return n;
    }

    static void initNativeStubs(Class<?> extension_class, Set supported_extensions, String ext_name) {
        GLContext.resetNativeStubs(extension_class);
        if (supported_extensions.contains(ext_name)) {
            try {
                AccessController.doPrivileged(new GLContext$2(extension_class));
            }
            catch (Exception exception) {
                LWJGLUtil.log("Failed to initialize extension " + extension_class + " - exception: " + exception);
                supported_extensions.remove(ext_name);
            }
        }
    }

    public static synchronized void useContext(Object context) {
        GLContext.useContext(context, false);
    }

    public static synchronized void useContext(Object context, boolean forwardCompatible) {
        if (context == null) {
            ContextCapabilities.unloadAllStubs();
            GLContext.setCapabilities(null);
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            return;
        }
        if (gl_ref_count == 0) {
            GLContext.loadOpenGLLibrary();
            did_auto_load = true;
        }
        try {
            ContextCapabilities contextCapabilities = capability_cache.get(context);
            if (contextCapabilities == null) {
                new ContextCapabilities(forwardCompatible);
                capability_cache.put(context, GLContext.getCapabilities());
            } else {
                GLContext.setCapabilities(contextCapabilities);
            }
        }
        catch (LWJGLException lWJGLException) {
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            throw lWJGLException;
        }
    }

    public static synchronized void loadOpenGLLibrary() {
        if (gl_ref_count == 0) {
            GLContext.nLoadOpenGLLibrary();
        }
        ++gl_ref_count;
    }

    private static native void nLoadOpenGLLibrary();

    public static synchronized void unloadOpenGLLibrary() {
        if (--gl_ref_count == 0 && LWJGLUtil.getPlatform() != 1) {
            GLContext.nUnloadOpenGLLibrary();
        }
    }

    private static native void nUnloadOpenGLLibrary();

    static native void resetNativeStubs(Class var0);

    static {
        Sys.initialize();
    }
}

