/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextGL;
import org.lwjgl.opengl.ContextImplementation;
import org.lwjgl.opengl.LinuxDisplay;
import org.lwjgl.opengl.PeerInfo;

final class LinuxContextImplementation
implements ContextImplementation {
    LinuxContextImplementation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer create(PeerInfo peer_info, IntBuffer attribs, ByteBuffer shared_context_handle) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = peer_info.lockAndGetHandle();
            try {
                ByteBuffer byteBuffer2 = LinuxContextImplementation.nCreate(byteBuffer, attribs, shared_context_handle);
                peer_info.unlock();
                return byteBuffer2;
            }
            catch (Throwable throwable) {
                peer_info.unlock();
                throw throwable;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nCreate(ByteBuffer var0, IntBuffer var1, ByteBuffer var2);

    native long getGLXContext(ByteBuffer var1);

    native long getDisplay(ByteBuffer var1);

    @Override
    public void releaseDrawable(ByteBuffer context_handle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        ContextGL contextGL = ContextGL.getCurrentContext();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            PeerInfo peerInfo = contextGL.getPeerInfo();
            LinuxDisplay.lockAWT();
            try {
                ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
                try {
                    LinuxContextImplementation.nSwapBuffers(byteBuffer);
                }
                finally {
                    peerInfo.unlock();
                }
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        }
    }

    private static native void nSwapBuffers(ByteBuffer var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCurrentContext() {
        ContextGL contextGL = ContextGL.getCurrentContext();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            PeerInfo peerInfo = contextGL.getPeerInfo();
            LinuxDisplay.lockAWT();
            try {
                ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
                try {
                    LinuxContextImplementation.nReleaseCurrentContext(byteBuffer);
                }
                finally {
                    peerInfo.unlock();
                }
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        }
    }

    private static native void nReleaseCurrentContext(ByteBuffer var0);

    @Override
    public void update(ByteBuffer context_handle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent(PeerInfo peer_info, ByteBuffer handle) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = peer_info.lockAndGetHandle();
            try {
                LinuxContextImplementation.nMakeCurrent(byteBuffer, handle);
            }
            finally {
                peer_info.unlock();
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nMakeCurrent(ByteBuffer var0, ByteBuffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrent(ByteBuffer handle) {
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            boolean bl2 = bl = LinuxContextImplementation.nIsCurrent(handle);
            return bl2;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsCurrent(ByteBuffer var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSwapInterval(int value) {
        ContextGL contextGL = ContextGL.getCurrentContext();
        PeerInfo peerInfo = contextGL.getPeerInfo();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            LinuxDisplay.lockAWT();
            try {
                ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
                try {
                    LinuxContextImplementation.nSetSwapInterval(byteBuffer, contextGL.getHandle(), value);
                }
                finally {
                    peerInfo.unlock();
                }
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
            finally {
                LinuxDisplay.unlockAWT();
            }
        }
    }

    private static native void nSetSwapInterval(ByteBuffer var0, ByteBuffer var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(PeerInfo peer_info, ByteBuffer handle) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = peer_info.lockAndGetHandle();
            try {
                LinuxContextImplementation.nDestroy(byteBuffer, handle);
            }
            finally {
                peer_info.unlock();
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nDestroy(ByteBuffer var0, ByteBuffer var1);
}

