/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.event.FocusListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.AWTCanvasImplementation;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.DrawableLWJGL;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.LinuxDisplay$1;
import org.lwjgl.opengl.LinuxDisplay$2;
import org.lwjgl.opengl.LinuxDisplay$3;
import org.lwjgl.opengl.LinuxDisplay$4;
import org.lwjgl.opengl.LinuxDisplay$Compiz;
import org.lwjgl.opengl.LinuxDisplayPeerInfo;
import org.lwjgl.opengl.LinuxEvent;
import org.lwjgl.opengl.LinuxKeyboard;
import org.lwjgl.opengl.LinuxMouse;
import org.lwjgl.opengl.LinuxPbufferPeerInfo;
import org.lwjgl.opengl.LinuxPeerInfo;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.XRandR$Screen;

final class LinuxDisplay
implements DisplayImplementation {
    public static final int CurrentTime = 0;
    public static final int GrabSuccess = 0;
    public static final int AutoRepeatModeOff = 0;
    public static final int AutoRepeatModeOn = 1;
    public static final int AutoRepeatModeDefault = 2;
    public static final int None = 0;
    private static final int KeyPressMask = 1;
    private static final int KeyReleaseMask = 2;
    private static final int ButtonPressMask = 4;
    private static final int ButtonReleaseMask = 8;
    private static final int NotifyAncestor = 0;
    private static final int NotifyNonlinear = 3;
    private static final int NotifyPointer = 5;
    private static final int NotifyPointerRoot = 6;
    private static final int NotifyDetailNone = 7;
    private static final int SetModeInsert = 0;
    private static final int SaveSetRoot = 1;
    private static final int SaveSetUnmap = 1;
    private static final int X_SetInputFocus = 42;
    private static final int FULLSCREEN_LEGACY = 1;
    private static final int FULLSCREEN_NETWM = 2;
    private static final int WINDOWED = 3;
    private static int current_window_mode = 3;
    private static final int XRANDR = 10;
    private static final int XF86VIDMODE = 11;
    private static final int NONE = 12;
    private static long display;
    private static long current_window;
    private static long saved_error_handler;
    private static int display_connection_usage_count;
    private final LinuxEvent event_buffer = new LinuxEvent();
    private final LinuxEvent tmp_event_buffer = new LinuxEvent();
    private int current_displaymode_extension = 12;
    private long delete_atom;
    private PeerInfo peer_info;
    private ByteBuffer saved_gamma;
    private ByteBuffer current_gamma;
    private DisplayMode saved_mode;
    private DisplayMode current_mode;
    private XRandR$Screen[] savedXrandrConfig;
    private boolean keyboard_grabbed;
    private boolean pointer_grabbed;
    private boolean input_released;
    private boolean grab;
    private boolean focused;
    private boolean minimized;
    private boolean dirty;
    private boolean close_requested;
    private long current_cursor;
    private long blank_cursor;
    private boolean mouseInside = true;
    private boolean resizable;
    private boolean resized;
    private int window_x;
    private int window_y;
    private int window_width;
    private int window_height;
    private Canvas parent;
    private long parent_window;
    private static boolean xembedded;
    private long parent_proxy_focus_window;
    private boolean parent_focused;
    private boolean parent_focus_changed;
    private long last_window_focus = 0L;
    private LinuxKeyboard keyboard;
    private LinuxMouse mouse;
    private String wm_class;
    private final FocusListener focus_listener = new LinuxDisplay$1(this);

    LinuxDisplay() {
    }

    private static ByteBuffer getCurrentGammaRamp() {
        LinuxDisplay.lockAWT();
        try {
            block8: {
                ByteBuffer byteBuffer;
                LinuxDisplay.incDisplay();
                try {
                    if (!LinuxDisplay.isXF86VidModeSupported()) break block8;
                    byteBuffer = LinuxDisplay.nGetCurrentGammaRamp(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
                }
                catch (Throwable throwable) {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                LinuxDisplay.decDisplay();
                return byteBuffer;
            }
            ByteBuffer byteBuffer = null;
            LinuxDisplay.decDisplay();
            return byteBuffer;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nGetCurrentGammaRamp(long var0, int var2);

    private static int getBestDisplayModeExtension() {
        int n;
        if (LinuxDisplay.isXrandrSupported()) {
            LWJGLUtil.log("Using Xrandr for display mode switching");
            n = 10;
        } else if (LinuxDisplay.isXF86VidModeSupported()) {
            LWJGLUtil.log("Using XF86VidMode for display mode switching");
            n = 11;
        } else {
            LWJGLUtil.log("No display mode extensions available");
            n = 12;
        }
        return n;
    }

    private static boolean isXrandrSupported() {
        if (Display.getPrivilegedBoolean("LWJGL_DISABLE_XRANDR")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsXrandrSupported(LinuxDisplay.getDisplay());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Got exception while querying Xrandr support: " + lWJGLException);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXrandrSupported(long var0);

    private static boolean isXF86VidModeSupported() {
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsXF86VidModeSupported(LinuxDisplay.getDisplay());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Got exception while querying XF86VM support: " + lWJGLException);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXF86VidModeSupported(long var0);

    private static boolean isNetWMFullscreenSupported() {
        if (Display.getPrivilegedBoolean("LWJGL_DISABLE_NETWM")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsNetWMFullscreenSupported(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Got exception while querying NetWM support: " + lWJGLException);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsNetWMFullscreenSupported(long var0, int var2);

    static void lockAWT() {
        try {
            LinuxDisplay.nLockAWT();
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Caught exception while locking AWT: " + lWJGLException);
        }
    }

    private static native void nLockAWT();

    static void unlockAWT() {
        try {
            LinuxDisplay.nUnlockAWT();
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Caught exception while unlocking AWT: " + lWJGLException);
        }
    }

    private static native void nUnlockAWT();

    static void incDisplay() {
        if (display_connection_usage_count == 0) {
            try {
                GLContext.loadOpenGLLibrary();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            saved_error_handler = LinuxDisplay.setErrorHandler();
            display = LinuxDisplay.openDisplay();
        }
        ++display_connection_usage_count;
    }

    private static native int callErrorHandler(long var0, long var2, long var4);

    private static native long setErrorHandler();

    private static native long resetErrorHandler(long var0);

    private static native void synchronize(long var0, boolean var2);

    private static int globalErrorHandler(long display, long event_ptr, long error_display, long serial, long error_code, long request_code, long minor_code) {
        if (xembedded && request_code == 42L) {
            return 0;
        }
        if (display == LinuxDisplay.getDisplay()) {
            String string = LinuxDisplay.getErrorText(display, error_code);
            throw new LWJGLException("X Error - disp: 0x" + Long.toHexString(error_display) + " serial: " + serial + " error: " + string + " request_code: " + request_code + " minor_code: " + minor_code);
        }
        if (saved_error_handler != 0L) {
            return LinuxDisplay.callErrorHandler(saved_error_handler, display, event_ptr);
        }
        return 0;
    }

    private static native String getErrorText(long var0, long var2);

    static void decDisplay() {
    }

    static native long openDisplay();

    static native void closeDisplay(long var0);

    private int getWindowMode(boolean fullscreen) {
        if (fullscreen) {
            if (this.current_displaymode_extension == 10 && LinuxDisplay.isNetWMFullscreenSupported()) {
                LWJGLUtil.log("Using NetWM for fullscreen window");
                return 2;
            }
            LWJGLUtil.log("Using legacy mode for fullscreen window");
            return 1;
        }
        return 3;
    }

    static long getDisplay() {
        if (display_connection_usage_count <= 0) {
            throw new InternalError("display_connection_usage_count = " + display_connection_usage_count);
        }
        return display;
    }

    static int getDefaultScreen() {
        return LinuxDisplay.nGetDefaultScreen(LinuxDisplay.getDisplay());
    }

    static native int nGetDefaultScreen(long var0);

    static long getWindow() {
        return current_window;
    }

    private void ungrabKeyboard() {
        if (this.keyboard_grabbed) {
            LinuxDisplay.nUngrabKeyboard(LinuxDisplay.getDisplay());
            this.keyboard_grabbed = false;
        }
    }

    static native int nUngrabKeyboard(long var0);

    private void grabKeyboard() {
        int n;
        if (!this.keyboard_grabbed && (n = LinuxDisplay.nGrabKeyboard(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow())) == 0) {
            this.keyboard_grabbed = true;
        }
    }

    static native int nGrabKeyboard(long var0, long var2);

    private void grabPointer() {
        int n;
        if (!this.pointer_grabbed && (n = LinuxDisplay.nGrabPointer(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), 0L)) == 0) {
            this.pointer_grabbed = true;
            if (LinuxDisplay.isLegacyFullscreen()) {
                LinuxDisplay.nSetViewPort(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getDefaultScreen());
            }
        }
    }

    static native int nGrabPointer(long var0, long var2, long var4);

    private static native void nSetViewPort(long var0, long var2, int var4);

    private void ungrabPointer() {
        if (this.pointer_grabbed) {
            this.pointer_grabbed = false;
            LinuxDisplay.nUngrabPointer(LinuxDisplay.getDisplay());
        }
    }

    static native int nUngrabPointer(long var0);

    private static boolean isFullscreen() {
        return current_window_mode == 1 || current_window_mode == 2;
    }

    private boolean shouldGrab() {
        return !this.input_released && this.grab && this.mouse != null;
    }

    private void updatePointerGrab() {
        if (LinuxDisplay.isFullscreen() || this.shouldGrab()) {
            this.grabPointer();
        } else {
            this.ungrabPointer();
        }
        this.updateCursor();
    }

    private void updateCursor() {
        long l = this.shouldGrab() ? this.blank_cursor : this.current_cursor;
        LinuxDisplay.nDefineCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), l);
    }

    private static native void nDefineCursor(long var0, long var2, long var4);

    private static boolean isLegacyFullscreen() {
        return current_window_mode == 1;
    }

    private void updateKeyboardGrab() {
        if (LinuxDisplay.isLegacyFullscreen()) {
            this.grabKeyboard();
        } else {
            this.ungrabKeyboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createWindow(DrawableLWJGL drawable, DisplayMode mode, Canvas parent, int x, int y) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                ByteBuffer byteBuffer = this.peer_info.lockAndGetHandle();
                try {
                    current_window_mode = this.getWindowMode(Display.isFullscreen());
                    if (current_window_mode != 3) {
                        LinuxDisplay$Compiz.setLegacyFullscreenSupport(true);
                    }
                    boolean bl = Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.undecorated") || current_window_mode != 3 && Display.getPrivilegedBoolean("org.lwjgl.opengl.Window.undecorated_fs");
                    this.parent = parent;
                    this.parent_window = parent != null ? LinuxDisplay.getHandle(parent) : LinuxDisplay.getRootWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
                    this.resizable = Display.isResizable();
                    this.resized = false;
                    this.window_x = x;
                    this.window_y = y;
                    this.window_width = mode.getWidth();
                    this.window_height = mode.getHeight();
                    current_window = LinuxDisplay.nCreateWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), byteBuffer, mode, current_window_mode, x, y, bl, this.parent_window, this.resizable);
                    this.wm_class = Display.getPrivilegedString("LWJGL_WM_CLASS");
                    if (this.wm_class == null) {
                        this.wm_class = Display.getTitle();
                    }
                    this.setClassHint(Display.getTitle(), this.wm_class);
                    LinuxDisplay.mapRaised(LinuxDisplay.getDisplay(), current_window);
                    xembedded = parent != null && LinuxDisplay.isAncestorXEmbedded(this.parent_window);
                    this.blank_cursor = LinuxDisplay.createBlankCursor();
                    this.current_cursor = 0L;
                    this.focused = false;
                    this.input_released = false;
                    this.pointer_grabbed = false;
                    this.keyboard_grabbed = false;
                    this.close_requested = false;
                    this.grab = false;
                    this.minimized = false;
                    this.dirty = true;
                    if (parent != null) {
                        parent.addFocusListener(this.focus_listener);
                        this.parent_focused = parent.isFocusOwner();
                        this.parent_focus_changed = true;
                    }
                }
                finally {
                    this.peer_info.unlock();
                }
            }
            catch (LWJGLException lWJGLException) {
                LinuxDisplay.decDisplay();
                throw lWJGLException;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native long nCreateWindow(long var0, int var2, ByteBuffer var3, DisplayMode var4, int var5, int var6, int var7, boolean var8, long var9, boolean var11);

    private static native long getRootWindow(long var0, int var2);

    private static native boolean hasProperty(long var0, long var2, long var4);

    private static native long getParentWindow(long var0, long var2);

    private static native int getChildCount(long var0, long var2);

    private static native void mapRaised(long var0, long var2);

    private static native void reparentWindow(long var0, long var2, long var4, int var6, int var7);

    private static native long nGetInputFocus(long var0);

    private static native void nSetInputFocus(long var0, long var2, long var4);

    private static native void nSetWindowSize(long var0, long var2, int var4, int var5, boolean var6);

    private static native int nGetX(long var0, long var2);

    private static native int nGetY(long var0, long var2);

    private static native int nGetWidth(long var0, long var2);

    private static native int nGetHeight(long var0, long var2);

    private static boolean isAncestorXEmbedded(long window) {
        long l = LinuxDisplay.internAtom("_XEMBED_INFO", true);
        if (l != 0L) {
            long l2 = window;
            while (l2 != 0L) {
                if (LinuxDisplay.hasProperty(LinuxDisplay.getDisplay(), l2, l)) {
                    return true;
                }
                l2 = LinuxDisplay.getParentWindow(LinuxDisplay.getDisplay(), l2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getHandle(Canvas parent) {
        AWTCanvasImplementation aWTCanvasImplementation = AWTGLCanvas.createImplementation();
        LinuxPeerInfo linuxPeerInfo = (LinuxPeerInfo)aWTCanvasImplementation.createPeerInfo(parent, null, null);
        ByteBuffer byteBuffer = linuxPeerInfo.lockAndGetHandle();
        try {
            long l = linuxPeerInfo.getDrawable();
            return l;
        }
        finally {
            linuxPeerInfo.unlock();
        }
    }

    private void updateInputGrab() {
        this.updatePointerGrab();
        this.updateKeyboardGrab();
    }

    @Override
    public void destroyWindow() {
        LinuxDisplay.lockAWT();
        try {
            if (this.parent != null) {
                this.parent.removeFocusListener(this.focus_listener);
            }
            try {
                this.setNativeCursor(null);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to reset cursor: " + lWJGLException.getMessage());
            }
            LinuxDisplay.nDestroyCursor(LinuxDisplay.getDisplay(), this.blank_cursor);
            this.blank_cursor = 0L;
            this.ungrabKeyboard();
            LinuxDisplay.nDestroyWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
            LinuxDisplay.decDisplay();
            if (current_window_mode != 3) {
                LinuxDisplay$Compiz.setLegacyFullscreenSupport(false);
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    static native void nDestroyWindow(long var0, long var2);

    @Override
    public void switchDisplayMode(DisplayMode mode) {
        LinuxDisplay.lockAWT();
        try {
            this.switchDisplayModeOnTmpDisplay(mode);
            this.current_mode = mode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private void switchDisplayModeOnTmpDisplay(DisplayMode mode) {
        LinuxDisplay.incDisplay();
        try {
            LinuxDisplay.nSwitchDisplayMode(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), this.current_displaymode_extension, mode);
        }
        finally {
            LinuxDisplay.decDisplay();
        }
    }

    private static native void nSwitchDisplayMode(long var0, int var2, int var3, DisplayMode var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long internAtom(String atom_name, boolean only_if_exists) {
        LinuxDisplay.incDisplay();
        try {
            long l = LinuxDisplay.nInternAtom(LinuxDisplay.getDisplay(), atom_name, only_if_exists);
            return l;
        }
        finally {
            LinuxDisplay.decDisplay();
        }
    }

    static native long nInternAtom(long var0, String var2, boolean var3);

    @Override
    public void resetDisplayMode() {
        LinuxDisplay.lockAWT();
        try {
            if (this.current_displaymode_extension == 10 && this.savedXrandrConfig.length > 0) {
                AccessController.doPrivileged(new LinuxDisplay$2(this));
            } else {
                this.switchDisplayMode(this.saved_mode);
            }
            if (LinuxDisplay.isXF86VidModeSupported()) {
                this.doSetGamma(this.saved_gamma);
            }
            LinuxDisplay$Compiz.setLegacyFullscreenSupport(false);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Caught exception while resetting mode: " + lWJGLException);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int getGammaRampLength() {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            return 0;
        }
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetGammaRampLength(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Got exception while querying gamma length: " + lWJGLException);
                int n2 = 0;
                LinuxDisplay.decDisplay();
                LinuxDisplay.unlockAWT();
                return n2;
                {
                    catch (Throwable throwable) {
                        try {
                            LinuxDisplay.decDisplay();
                            throw throwable;
                        }
                        catch (LWJGLException lWJGLException2) {
                            LWJGLUtil.log("Failed to get gamma ramp length: " + lWJGLException2);
                            int n3 = 0;
                            return n3;
                        }
                    }
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetGammaRampLength(long var0, int var2);

    @Override
    public void setGammaRamp(FloatBuffer gammaRamp) {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            throw new LWJGLException("No gamma ramp support (Missing XF86VM extension)");
        }
        this.doSetGamma(LinuxDisplay.convertToNativeRamp(gammaRamp));
    }

    private void doSetGamma(ByteBuffer native_gamma) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.setGammaRampOnTmpDisplay(native_gamma);
            this.current_gamma = native_gamma;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static void setGammaRampOnTmpDisplay(ByteBuffer native_gamma) {
        LinuxDisplay.incDisplay();
        try {
            LinuxDisplay.nSetGammaRamp(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), native_gamma);
        }
        finally {
            LinuxDisplay.decDisplay();
        }
    }

    private static native void nSetGammaRamp(long var0, int var2, ByteBuffer var3);

    private static ByteBuffer convertToNativeRamp(FloatBuffer ramp) {
        return LinuxDisplay.nConvertToNativeRamp(ramp, ramp.position(), ramp.remaining());
    }

    private static native ByteBuffer nConvertToNativeRamp(FloatBuffer var0, int var1, int var2);

    @Override
    public String getAdapter() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public DisplayMode init() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay$Compiz.init();
            this.delete_atom = LinuxDisplay.internAtom("WM_DELETE_WINDOW", false);
            this.current_displaymode_extension = LinuxDisplay.getBestDisplayModeExtension();
            if (this.current_displaymode_extension == 12) {
                throw new LWJGLException("No display mode extension is available");
            }
            DisplayMode[] displayModeArray = this.getAvailableDisplayModes();
            if (displayModeArray == null || displayModeArray.length == 0) {
                throw new LWJGLException("No modes available");
            }
            switch (this.current_displaymode_extension) {
                case 10: {
                    this.savedXrandrConfig = AccessController.doPrivileged(new LinuxDisplay$3(this));
                    this.saved_mode = LinuxDisplay.getCurrentXRandrMode();
                    break;
                }
                case 11: {
                    this.saved_mode = displayModeArray[0];
                    break;
                }
                default: {
                    throw new LWJGLException("Unknown display mode extension: " + this.current_displaymode_extension);
                }
            }
            this.current_mode = this.saved_mode;
            this.current_gamma = this.saved_gamma = LinuxDisplay.getCurrentGammaRamp();
            DisplayMode displayMode = this.saved_mode;
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static DisplayMode getCurrentXRandrMode() {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode displayMode;
            LinuxDisplay.incDisplay();
            try {
                displayMode = LinuxDisplay.nGetCurrentXRandrMode(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode nGetCurrentXRandrMode(long var0, int var2);

    @Override
    public void setTitle(String title) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = MemoryUtil.encodeUTF8(title);
            LinuxDisplay.nSetTitle(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), MemoryUtil.getAddress(byteBuffer), byteBuffer.remaining() - 1);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
        if (Display.isCreated()) {
            this.setClassHint(title, this.wm_class);
        }
    }

    private static native void nSetTitle(long var0, long var2, long var4, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassHint(String wm_name, String wm_class) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer = MemoryUtil.encodeUTF8(wm_name);
            ByteBuffer byteBuffer2 = MemoryUtil.encodeUTF8(wm_class);
            LinuxDisplay.nSetClassHint(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), MemoryUtil.getAddress(byteBuffer), MemoryUtil.getAddress(byteBuffer2));
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetClassHint(long var0, long var2, long var4, long var6);

    @Override
    public boolean isCloseRequested() {
        boolean bl = this.close_requested;
        this.close_requested = false;
        return bl;
    }

    @Override
    public boolean isVisible() {
        return !this.minimized;
    }

    @Override
    public boolean isActive() {
        return this.focused || LinuxDisplay.isLegacyFullscreen();
    }

    @Override
    public boolean isDirty() {
        boolean bl = this.dirty;
        this.dirty = false;
        return bl;
    }

    @Override
    public PeerInfo createPeerInfo(PixelFormat pixel_format, ContextAttribs attribs) {
        this.peer_info = new LinuxDisplayPeerInfo(pixel_format);
        return this.peer_info;
    }

    private void relayEventToParent(LinuxEvent event_buffer, int event_mask) {
        this.tmp_event_buffer.copyFrom(event_buffer);
        this.tmp_event_buffer.setWindow(this.parent_window);
        this.tmp_event_buffer.sendEvent(LinuxDisplay.getDisplay(), this.parent_window, true, event_mask);
    }

    private void relayEventToParent(LinuxEvent event_buffer) {
        if (this.parent == null) {
            return;
        }
        switch (event_buffer.getType()) {
            case 2: {
                this.relayEventToParent(event_buffer, 1);
                break;
            }
            case 3: {
                this.relayEventToParent(event_buffer, 1);
                break;
            }
            case 4: {
                if (!xembedded && this.focused) break;
                this.relayEventToParent(event_buffer, 1);
                break;
            }
            case 5: {
                if (!xembedded && this.focused) break;
                this.relayEventToParent(event_buffer, 1);
                break;
            }
        }
    }

    private void processEvents() {
        while (LinuxEvent.getPending(LinuxDisplay.getDisplay()) > 0) {
            this.event_buffer.nextEvent(LinuxDisplay.getDisplay());
            long l = this.event_buffer.getWindow();
            this.relayEventToParent(this.event_buffer);
            if (l != LinuxDisplay.getWindow() || this.event_buffer.filterEvent(l) || this.mouse != null && this.mouse.filterEvent(this.grab, this.shouldWarpPointer(), this.event_buffer) || this.keyboard != null && this.keyboard.filterEvent(this.event_buffer)) continue;
            switch (this.event_buffer.getType()) {
                case 9: {
                    this.setFocused(true, this.event_buffer.getFocusDetail());
                    break;
                }
                case 10: {
                    this.setFocused(false, this.event_buffer.getFocusDetail());
                    break;
                }
                case 33: {
                    if (this.event_buffer.getClientFormat() != 32 || (long)this.event_buffer.getClientData(0) != this.delete_atom) break;
                    this.close_requested = true;
                    break;
                }
                case 19: {
                    this.dirty = true;
                    this.minimized = false;
                    break;
                }
                case 18: {
                    this.dirty = true;
                    this.minimized = true;
                    break;
                }
                case 12: {
                    this.dirty = true;
                    break;
                }
                case 22: {
                    int n = LinuxDisplay.nGetX(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    int n2 = LinuxDisplay.nGetY(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    int n3 = LinuxDisplay.nGetWidth(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    int n4 = LinuxDisplay.nGetHeight(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
                    this.window_x = n;
                    this.window_y = n2;
                    if (this.window_width == n3 && this.window_height == n4) break;
                    this.resized = true;
                    this.window_width = n3;
                    this.window_height = n4;
                    break;
                }
                case 7: {
                    this.mouseInside = true;
                    break;
                }
                case 8: {
                    this.mouseInside = false;
                    break;
                }
            }
        }
    }

    @Override
    public void update() {
        LinuxDisplay.lockAWT();
        try {
            this.processEvents();
            this.checkInput();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(int x, int y, int width, int height) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nReshape(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), x, y, width, height);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nReshape(long var0, long var2, int var4, int var5, int var6, int var7);

    @Override
    public DisplayMode[] getAvailableDisplayModes() {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode[] displayModeArray;
            LinuxDisplay.incDisplay();
            try {
                DisplayMode[] displayModeArray2;
                displayModeArray = displayModeArray2 = LinuxDisplay.nGetAvailableDisplayModes(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), this.current_displaymode_extension);
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayModeArray;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode[] nGetAvailableDisplayModes(long var0, int var2, int var3);

    @Override
    public boolean hasWheel() {
        return true;
    }

    @Override
    public int getButtonCount() {
        return this.mouse.getButtonCount();
    }

    @Override
    public void createMouse() {
        LinuxDisplay.lockAWT();
        try {
            this.mouse = new LinuxMouse(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getWindow());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public void destroyMouse() {
        this.mouse = null;
        this.updateInputGrab();
    }

    @Override
    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.poll(this.grab, coord_buffer, buttons);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public void readMouse(ByteBuffer buffer) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.read(buffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public void setCursorPosition(int x, int y) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.setCursorPosition(x, y);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private void checkInput() {
        if (this.parent == null) {
            return;
        }
        if (xembedded) {
            long l = 0L;
            if (this.last_window_focus != l || this.parent_focused != this.focused) {
                if (this.isParentWindowActive(l)) {
                    if (this.parent_focused) {
                        LinuxDisplay.nSetInputFocus(LinuxDisplay.getDisplay(), current_window, 0L);
                        this.last_window_focus = current_window;
                        this.focused = true;
                    } else {
                        LinuxDisplay.nSetInputFocus(LinuxDisplay.getDisplay(), this.parent_proxy_focus_window, 0L);
                        this.last_window_focus = this.parent_proxy_focus_window;
                        this.focused = false;
                    }
                } else {
                    this.last_window_focus = l;
                    this.focused = false;
                }
            }
        } else if (this.parent_focus_changed && this.parent_focused) {
            this.setInputFocusUnsafe(LinuxDisplay.getWindow());
            this.parent_focus_changed = false;
        }
    }

    private void setInputFocusUnsafe(long window) {
        try {
            LinuxDisplay.nSetInputFocus(LinuxDisplay.getDisplay(), window, 0L);
            LinuxDisplay.nSync(LinuxDisplay.getDisplay(), false);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Got exception while trying to focus: " + lWJGLException);
        }
    }

    private static native void nSync(long var0, boolean var2);

    private boolean isParentWindowActive(long window) {
        try {
            if (window == current_window) {
                return true;
            }
            if (LinuxDisplay.getChildCount(LinuxDisplay.getDisplay(), window) != 0) {
                return false;
            }
            long l = LinuxDisplay.getParentWindow(LinuxDisplay.getDisplay(), window);
            if (l == 0L) {
                return false;
            }
            long l2 = current_window;
            while (l2 != 0L) {
                l2 = LinuxDisplay.getParentWindow(LinuxDisplay.getDisplay(), l2);
                if (l2 != l) continue;
                this.parent_proxy_focus_window = window;
                return true;
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to detect if parent window is active: " + lWJGLException.getMessage());
            return true;
        }
        return false;
    }

    private void setFocused(boolean got_focus, int focus_detail) {
        if (this.focused == got_focus || focus_detail == 7 || focus_detail == 5 || focus_detail == 6 || xembedded) {
            return;
        }
        this.focused = got_focus;
        if (this.focused) {
            this.acquireInput();
        } else {
            this.releaseInput();
        }
    }

    private void releaseInput() {
        if (LinuxDisplay.isLegacyFullscreen() || this.input_released) {
            return;
        }
        this.input_released = true;
        this.updateInputGrab();
        if (current_window_mode == 2) {
            LinuxDisplay.nIconifyWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getDefaultScreen());
            try {
                if (this.current_displaymode_extension == 10 && this.savedXrandrConfig.length > 0) {
                    AccessController.doPrivileged(new LinuxDisplay$4(this));
                } else {
                    this.switchDisplayModeOnTmpDisplay(this.saved_mode);
                }
                LinuxDisplay.setGammaRampOnTmpDisplay(this.saved_gamma);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to restore saved mode: " + lWJGLException.getMessage());
            }
        }
    }

    private static native void nIconifyWindow(long var0, long var2, int var4);

    private void acquireInput() {
        if (LinuxDisplay.isLegacyFullscreen() || !this.input_released) {
            return;
        }
        this.input_released = false;
        this.updateInputGrab();
        if (current_window_mode == 2) {
            try {
                this.switchDisplayModeOnTmpDisplay(this.current_mode);
                LinuxDisplay.setGammaRampOnTmpDisplay(this.current_gamma);
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to restore mode: " + lWJGLException.getMessage());
            }
        }
    }

    @Override
    public void grabMouse(boolean new_grab) {
        LinuxDisplay.lockAWT();
        try {
            if (new_grab != this.grab) {
                this.grab = new_grab;
                this.updateInputGrab();
                this.mouse.changeGrabbed(this.grab, this.shouldWarpPointer());
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private boolean shouldWarpPointer() {
        return this.pointer_grabbed && this.shouldGrab();
    }

    @Override
    public int getNativeCursorCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetNativeCursorCapabilities(LinuxDisplay.getDisplay());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    throw new RuntimeException(lWJGLException);
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetNativeCursorCapabilities(long var0);

    @Override
    public void setNativeCursor(Object handle) {
        this.current_cursor = LinuxDisplay.getCursorHandle(handle);
        LinuxDisplay.lockAWT();
        try {
            this.updateCursor();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public int getMinCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetMinCursorSize(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Exception occurred in getMinCursorSize: " + lWJGLException);
                    int n2 = 0;
                    return n2;
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMinCursorSize(long var0, long var2);

    @Override
    public int getMaxCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetMaxCursorSize(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Exception occurred in getMaxCursorSize: " + lWJGLException);
                    int n2 = 0;
                    return n2;
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMaxCursorSize(long var0, long var2);

    @Override
    public void createKeyboard() {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard = new LinuxKeyboard(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public void destroyKeyboard() {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.destroy(LinuxDisplay.getDisplay());
            this.keyboard = null;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.poll(keyDownBuffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    @Override
    public void readKeyboard(ByteBuffer buffer) {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.read(buffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native long nCreateCursor(long var0, int var2, int var3, int var4, int var5, int var6, IntBuffer var7, int var8, IntBuffer var9, int var10);

    private static long createBlankCursor() {
        return LinuxDisplay.nCreateBlankCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
    }

    static native long nCreateBlankCursor(long var0, long var2);

    @Override
    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                long l = LinuxDisplay.nCreateCursor(LinuxDisplay.getDisplay(), width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
                Long l2 = l;
                return l2;
            }
            catch (LWJGLException lWJGLException) {
                LinuxDisplay.decDisplay();
                throw lWJGLException;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static long getCursorHandle(Object cursor_handle) {
        return cursor_handle != null ? (Long)cursor_handle : 0L;
    }

    @Override
    public void destroyCursor(Object cursorHandle) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nDestroyCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getCursorHandle(cursorHandle));
            LinuxDisplay.decDisplay();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    static native void nDestroyCursor(long var0, long var2);

    @Override
    public int getPbufferCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetPbufferCapabilities(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen());
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtil.log("Exception occurred in getPbufferCapabilities: " + lWJGLException);
                    int n2 = 0;
                    return n2;
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetPbufferCapabilities(long var0, int var2);

    @Override
    public boolean isBufferLost(PeerInfo handle) {
        return false;
    }

    @Override
    public PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, ContextAttribs attribs, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs) {
        return new LinuxPbufferPeerInfo(width, height, pixel_format);
    }

    @Override
    public void setPbufferAttrib(PeerInfo handle, int attrib, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bindTexImageToPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseTexImageFromPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    private static ByteBuffer convertIcons(ByteBuffer[] icons) {
        int n;
        int n2 = 0;
        for (ByteBuffer byteBuffer : icons) {
            int n3 = byteBuffer.limit() / 4;
            n = (int)Math.sqrt(n3);
            if (n <= 0) continue;
            n2 += 8;
            n2 += n * n * 4;
        }
        if (n2 == 0) {
            return null;
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n2);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        for (ByteBuffer byteBuffer2 : icons) {
            n = byteBuffer2.limit() / 4;
            int n4 = (int)Math.sqrt(n);
            byteBuffer.putInt(n4);
            byteBuffer.putInt(n4);
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n4; ++j) {
                    byte by = byteBuffer2.get(j * 4 + i * n4 * 4);
                    byte by2 = byteBuffer2.get(j * 4 + i * n4 * 4 + 1);
                    byte by3 = byteBuffer2.get(j * 4 + i * n4 * 4 + 2);
                    byte by4 = byteBuffer2.get(j * 4 + i * n4 * 4 + 3);
                    byteBuffer.put(by4);
                    byteBuffer.put(by);
                    byteBuffer.put(by2);
                    byteBuffer.put(by3);
                }
            }
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setIcon(ByteBuffer[] icons) {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer byteBuffer;
            block10: {
                int n;
                LinuxDisplay.incDisplay();
                try {
                    byteBuffer = LinuxDisplay.convertIcons(icons);
                    if (byteBuffer != null) break block10;
                    n = 0;
                }
                catch (Throwable throwable) {
                    try {
                        LinuxDisplay.decDisplay();
                        throw throwable;
                    }
                    catch (LWJGLException lWJGLException) {
                        LWJGLUtil.log("Failed to set display icon: " + lWJGLException);
                        int n2 = 0;
                        return n2;
                    }
                }
                LinuxDisplay.decDisplay();
                return n;
            }
            LinuxDisplay.nSetWindowIcon(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), byteBuffer, byteBuffer.capacity());
            int n = icons.length;
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetWindowIcon(long var0, long var2, ByteBuffer var4, int var5);

    @Override
    public int getX() {
        return this.window_x;
    }

    @Override
    public int getY() {
        return this.window_y;
    }

    @Override
    public int getWidth() {
        return this.window_width;
    }

    @Override
    public int getHeight() {
        return this.window_height;
    }

    @Override
    public boolean isInsideWindow() {
        return this.mouseInside;
    }

    @Override
    public void setResizable(boolean resizable) {
        if (this.resizable == resizable) {
            return;
        }
        this.resizable = resizable;
        LinuxDisplay.nSetWindowSize(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), this.window_width, this.window_height, resizable);
    }

    @Override
    public boolean wasResized() {
        if (this.resized) {
            this.resized = false;
            return true;
        }
        return false;
    }

    @Override
    public float getPixelScaleFactor() {
        return 1.0f;
    }

    static /* synthetic */ boolean access$002(LinuxDisplay x0, boolean x1) {
        x0.parent_focused = x1;
        return x0.parent_focused;
    }

    static /* synthetic */ boolean access$102(LinuxDisplay x0, boolean x1) {
        x0.parent_focus_changed = x1;
        return x0.parent_focus_changed;
    }

    static /* synthetic */ XRandR$Screen[] access$200(LinuxDisplay x0) {
        return x0.savedXrandrConfig;
    }
}

