/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.LinuxDisplay;
import org.lwjgl.opengl.LinuxPeerInfo;
import org.lwjgl.opengl.PixelFormat;

final class LinuxDisplayPeerInfo
extends LinuxPeerInfo {
    final boolean egl;

    LinuxDisplayPeerInfo() {
        this.egl = true;
    }

    LinuxDisplayPeerInfo(PixelFormat pixel_format) {
        this.egl = false;
        LinuxDisplay.lockAWT();
        try {
            GLContext.loadOpenGLLibrary();
            try {
                LinuxDisplay.incDisplay();
                try {
                    LinuxDisplayPeerInfo.initDefaultPeerInfo(LinuxDisplay.getDisplay(), LinuxDisplay.getDefaultScreen(), this.getHandle(), pixel_format);
                }
                catch (LWJGLException lWJGLException) {
                    LinuxDisplay.decDisplay();
                    throw lWJGLException;
                }
            }
            catch (LWJGLException lWJGLException) {
                GLContext.unloadOpenGLLibrary();
                throw lWJGLException;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void initDefaultPeerInfo(long var0, int var2, ByteBuffer var3, PixelFormat var4);

    @Override
    protected void doLockAndInitHandle() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplayPeerInfo.initDrawable(LinuxDisplay.getWindow(), this.getHandle());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void initDrawable(long var0, ByteBuffer var2);

    @Override
    protected void doUnlock() {
    }

    @Override
    public void destroy() {
        super.destroy();
        LinuxDisplay.lockAWT();
        LinuxDisplay.decDisplay();
        GLContext.unloadOpenGLLibrary();
        LinuxDisplay.unlockAWT();
    }
}

