/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class NVPathRendering {
    public static final int GL_CLOSE_PATH_NV = 0;
    public static final int GL_MOVE_TO_NV = 2;
    public static final int GL_RELATIVE_MOVE_TO_NV = 3;
    public static final int GL_LINE_TO_NV = 4;
    public static final int GL_RELATIVE_LINE_TO_NV = 5;
    public static final int GL_HORIZONTAL_LINE_TO_NV = 6;
    public static final int GL_RELATIVE_HORIZONTAL_LINE_TO_NV = 7;
    public static final int GL_VERTICAL_LINE_TO_NV = 8;
    public static final int GL_RELATIVE_VERTICAL_LINE_TO_NV = 9;
    public static final int GL_QUADRATIC_CURVE_TO_NV = 10;
    public static final int GL_RELATIVE_QUADRATIC_CURVE_TO_NV = 11;
    public static final int GL_CUBIC_CURVE_TO_NV = 12;
    public static final int GL_RELATIVE_CUBIC_CURVE_TO_NV = 13;
    public static final int GL_SMOOTH_QUADRATIC_CURVE_TO_NV = 14;
    public static final int GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 15;
    public static final int GL_SMOOTH_CUBIC_CURVE_TO_NV = 16;
    public static final int GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 17;
    public static final int GL_SMALL_CCW_ARC_TO_NV = 18;
    public static final int GL_RELATIVE_SMALL_CCW_ARC_TO_NV = 19;
    public static final int GL_SMALL_CW_ARC_TO_NV = 20;
    public static final int GL_RELATIVE_SMALL_CW_ARC_TO_NV = 21;
    public static final int GL_LARGE_CCW_ARC_TO_NV = 22;
    public static final int GL_RELATIVE_LARGE_CCW_ARC_TO_NV = 23;
    public static final int GL_LARGE_CW_ARC_TO_NV = 24;
    public static final int GL_RELATIVE_LARGE_CW_ARC_TO_NV = 25;
    public static final int GL_CIRCULAR_CCW_ARC_TO_NV = 248;
    public static final int GL_CIRCULAR_CW_ARC_TO_NV = 250;
    public static final int GL_CIRCULAR_TANGENT_ARC_TO_NV = 252;
    public static final int GL_ARC_TO_NV = 254;
    public static final int GL_RELATIVE_ARC_TO_NV = 255;
    public static final int GL_PATH_FORMAT_SVG_NV = 36976;
    public static final int GL_PATH_FORMAT_PS_NV = 36977;
    public static final int GL_STANDARD_FONT_NAME_NV = 36978;
    public static final int GL_SYSTEM_FONT_NAME_NV = 36979;
    public static final int GL_FILE_NAME_NV = 36980;
    public static final int GL_SKIP_MISSING_GLYPH_NV = 37033;
    public static final int GL_USE_MISSING_GLYPH_NV = 37034;
    public static final int GL_PATH_STROKE_WIDTH_NV = 36981;
    public static final int GL_PATH_INITIAL_END_CAP_NV = 36983;
    public static final int GL_PATH_TERMINAL_END_CAP_NV = 36984;
    public static final int GL_PATH_JOIN_STYLE_NV = 36985;
    public static final int GL_PATH_MITER_LIMIT_NV = 36986;
    public static final int GL_PATH_INITIAL_DASH_CAP_NV = 36988;
    public static final int GL_PATH_TERMINAL_DASH_CAP_NV = 36989;
    public static final int GL_PATH_DASH_OFFSET_NV = 36990;
    public static final int GL_PATH_CLIENT_LENGTH_NV = 36991;
    public static final int GL_PATH_DASH_OFFSET_RESET_NV = 37044;
    public static final int GL_PATH_FILL_MODE_NV = 36992;
    public static final int GL_PATH_FILL_MASK_NV = 36993;
    public static final int GL_PATH_FILL_COVER_MODE_NV = 36994;
    public static final int GL_PATH_STROKE_COVER_MODE_NV = 36995;
    public static final int GL_PATH_STROKE_MASK_NV = 36996;
    public static final int GL_PATH_END_CAPS_NV = 36982;
    public static final int GL_PATH_DASH_CAPS_NV = 36987;
    public static final int GL_COUNT_UP_NV = 37000;
    public static final int GL_COUNT_DOWN_NV = 37001;
    public static final int GL_PRIMARY_COLOR = 34167;
    public static final int GL_PRIMARY_COLOR_NV = 34092;
    public static final int GL_SECONDARY_COLOR_NV = 34093;
    public static final int GL_PATH_OBJECT_BOUNDING_BOX_NV = 37002;
    public static final int GL_CONVEX_HULL_NV = 37003;
    public static final int GL_BOUNDING_BOX_NV = 37005;
    public static final int GL_TRANSLATE_X_NV = 37006;
    public static final int GL_TRANSLATE_Y_NV = 37007;
    public static final int GL_TRANSLATE_2D_NV = 37008;
    public static final int GL_TRANSLATE_3D_NV = 37009;
    public static final int GL_AFFINE_2D_NV = 37010;
    public static final int GL_AFFINE_3D_NV = 37012;
    public static final int GL_TRANSPOSE_AFFINE_2D_NV = 37014;
    public static final int GL_TRANSPOSE_AFFINE_3D_NV = 37016;
    public static final int GL_UTF8_NV = 37018;
    public static final int GL_UTF16_NV = 37019;
    public static final int GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 37020;
    public static final int GL_PATH_COMMAND_COUNT_NV = 37021;
    public static final int GL_PATH_COORD_COUNT_NV = 37022;
    public static final int GL_PATH_DASH_ARRAY_COUNT_NV = 37023;
    public static final int GL_PATH_COMPUTED_LENGTH_NV = 37024;
    public static final int GL_PATH_FILL_BOUNDING_BOX_NV = 37025;
    public static final int GL_PATH_STROKE_BOUNDING_BOX_NV = 37026;
    public static final int GL_SQUARE_NV = 37027;
    public static final int GL_ROUND_NV = 37028;
    public static final int GL_TRIANGULAR_NV = 37029;
    public static final int GL_BEVEL_NV = 37030;
    public static final int GL_MITER_REVERT_NV = 37031;
    public static final int GL_MITER_TRUNCATE_NV = 37032;
    public static final int GL_MOVE_TO_RESETS_NV = 37045;
    public static final int GL_MOVE_TO_CONTINUES_NV = 37046;
    public static final int GL_BOLD_BIT_NV = 1;
    public static final int GL_ITALIC_BIT_NV = 2;
    public static final int GL_PATH_ERROR_POSITION_NV = 37035;
    public static final int GL_PATH_FOG_GEN_MODE_NV = 37036;
    public static final int GL_PATH_STENCIL_FUNC_NV = 37047;
    public static final int GL_PATH_STENCIL_REF_NV = 37048;
    public static final int GL_PATH_STENCIL_VALUE_MASK_NV = 37049;
    public static final int GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 37053;
    public static final int GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 37054;
    public static final int GL_PATH_COVER_DEPTH_FUNC_NV = 37055;
    public static final int GL_GLYPH_WIDTH_BIT_NV = 1;
    public static final int GL_GLYPH_HEIGHT_BIT_NV = 2;
    public static final int GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 4;
    public static final int GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 8;
    public static final int GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 16;
    public static final int GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = 32;
    public static final int GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 64;
    public static final int GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 128;
    public static final int GL_GLYPH_HAS_KERNING_NV = 256;
    public static final int GL_FONT_X_MIN_BOUNDS_NV = 65536;
    public static final int GL_FONT_Y_MIN_BOUNDS_NV = 131072;
    public static final int GL_FONT_X_MAX_BOUNDS_NV = 262144;
    public static final int GL_FONT_Y_MAX_BOUNDS_NV = 524288;
    public static final int GL_FONT_UNITS_PER_EM_NV = 0x100000;
    public static final int GL_FONT_ASCENDER_NV = 0x200000;
    public static final int GL_FONT_DESCENDER_NV = 0x400000;
    public static final int GL_FONT_HEIGHT_NV = 0x800000;
    public static final int GL_FONT_MAX_ADVANCE_WIDTH_NV = 0x1000000;
    public static final int GL_FONT_MAX_ADVANCE_HEIGHT_NV = 0x2000000;
    public static final int GL_FONT_UNDERLINE_POSITION_NV = 0x4000000;
    public static final int GL_FONT_UNDERLINE_THICKNESS_NV = 0x8000000;
    public static final int GL_FONT_HAS_KERNING_NV = 0x10000000;
    public static final int GL_ACCUM_ADJACENT_PAIRS_NV = 37037;
    public static final int GL_ADJACENT_PAIRS_NV = 37038;
    public static final int GL_FIRST_TO_REST_NV = 37039;
    public static final int GL_PATH_GEN_MODE_NV = 37040;
    public static final int GL_PATH_GEN_COEFF_NV = 37041;
    public static final int GL_PATH_GEN_COLOR_FORMAT_NV = 37042;
    public static final int GL_PATH_GEN_COMPONENTS_NV = 37043;

    private NVPathRendering() {
    }

    public static void glPathCommandsNV(int path, ByteBuffer commands, int coordType, ByteBuffer coords) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathCommandsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(commands);
        BufferChecks.checkDirect(coords);
        NVPathRendering.nglPathCommandsNV(path, commands.remaining(), MemoryUtil.getAddress(commands), coords.remaining(), coordType, MemoryUtil.getAddress(coords), l);
    }

    static native void nglPathCommandsNV(int var0, int var1, long var2, int var4, int var5, long var6, long var8);

    public static void glPathCoordsNV(int path, int coordType, ByteBuffer coords) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathCoordsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(coords);
        NVPathRendering.nglPathCoordsNV(path, coords.remaining(), coordType, MemoryUtil.getAddress(coords), l);
    }

    static native void nglPathCoordsNV(int var0, int var1, int var2, long var3, long var5);

    public static void glPathSubCommandsNV(int path, int commandStart, int commandsToDelete, ByteBuffer commands, int coordType, ByteBuffer coords) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathSubCommandsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(commands);
        BufferChecks.checkDirect(coords);
        NVPathRendering.nglPathSubCommandsNV(path, commandStart, commandsToDelete, commands.remaining(), MemoryUtil.getAddress(commands), coords.remaining(), coordType, MemoryUtil.getAddress(coords), l);
    }

    static native void nglPathSubCommandsNV(int var0, int var1, int var2, int var3, long var4, int var6, int var7, long var8, long var10);

    public static void glPathSubCoordsNV(int path, int coordStart, int coordType, ByteBuffer coords) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathSubCoordsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(coords);
        NVPathRendering.nglPathSubCoordsNV(path, coordStart, coords.remaining(), coordType, MemoryUtil.getAddress(coords), l);
    }

    static native void nglPathSubCoordsNV(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glPathStringNV(int path, int format, ByteBuffer pathString) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathStringNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pathString);
        NVPathRendering.nglPathStringNV(path, format, pathString.remaining(), MemoryUtil.getAddress(pathString), l);
    }

    static native void nglPathStringNV(int var0, int var1, int var2, long var3, long var5);

    public static void glPathGlyphsNV(int firstPathName, int fontTarget, ByteBuffer fontName, int fontStyle, int type, ByteBuffer charcodes, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathGlyphsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(fontName);
        BufferChecks.checkNullTerminated(fontName);
        BufferChecks.checkDirect(charcodes);
        NVPathRendering.nglPathGlyphsNV(firstPathName, fontTarget, MemoryUtil.getAddress(fontName), fontStyle, charcodes.remaining() / GLChecks.calculateBytesPerCharCode(type), type, MemoryUtil.getAddress(charcodes), handleMissingGlyphs, pathParameterTemplate, emScale, l);
    }

    static native void nglPathGlyphsNV(int var0, int var1, long var2, int var4, int var5, int var6, long var7, int var9, int var10, float var11, long var12);

    public static void glPathGlyphRangeNV(int firstPathName, int fontTarget, ByteBuffer fontName, int fontStyle, int firstGlyph, int numGlyphs, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathGlyphRangeNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(fontName);
        BufferChecks.checkNullTerminated(fontName);
        NVPathRendering.nglPathGlyphRangeNV(firstPathName, fontTarget, MemoryUtil.getAddress(fontName), fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale, l);
    }

    static native void nglPathGlyphRangeNV(int var0, int var1, long var2, int var4, int var5, int var6, int var7, int var8, float var9, long var10);

    public static void glWeightPathsNV(int resultPath, IntBuffer paths, FloatBuffer weights) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glWeightPathsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paths);
        BufferChecks.checkBuffer(weights, paths.remaining());
        NVPathRendering.nglWeightPathsNV(resultPath, paths.remaining(), MemoryUtil.getAddress(paths), MemoryUtil.getAddress(weights), l);
    }

    static native void nglWeightPathsNV(int var0, int var1, long var2, long var4, long var6);

    public static void glCopyPathNV(int resultPath, int srcPath) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCopyPathNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglCopyPathNV(resultPath, srcPath, l);
    }

    static native void nglCopyPathNV(int var0, int var1, long var2);

    public static void glInterpolatePathsNV(int resultPath, int pathA, int pathB, float weight) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glInterpolatePathsNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglInterpolatePathsNV(resultPath, pathA, pathB, weight, l);
    }

    static native void nglInterpolatePathsNV(int var0, int var1, int var2, float var3, long var4);

    public static void glTransformPathNV(int resultPath, int srcPath, int transformType, FloatBuffer transformValues) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTransformPathNV;
        BufferChecks.checkFunctionAddress(l);
        if (transformValues != null) {
            BufferChecks.checkBuffer(transformValues, GLChecks.calculateTransformPathValues(transformType));
        }
        NVPathRendering.nglTransformPathNV(resultPath, srcPath, transformType, MemoryUtil.getAddressSafe(transformValues), l);
    }

    static native void nglTransformPathNV(int var0, int var1, int var2, long var3, long var5);

    public static void glPathParameterNV(int path, int pname, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathParameterivNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 4);
        NVPathRendering.nglPathParameterivNV(path, pname, MemoryUtil.getAddress(value), l);
    }

    static native void nglPathParameterivNV(int var0, int var1, long var2, long var4);

    public static void glPathParameteriNV(int path, int pname, int value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathParameteriNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglPathParameteriNV(path, pname, value, l);
    }

    static native void nglPathParameteriNV(int var0, int var1, int var2, long var3);

    public static void glPathParameterfNV(int path, int pname, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathParameterfvNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 4);
        NVPathRendering.nglPathParameterfvNV(path, pname, MemoryUtil.getAddress(value), l);
    }

    static native void nglPathParameterfvNV(int var0, int var1, long var2, long var4);

    public static void glPathParameterfNV(int path, int pname, float value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathParameterfNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglPathParameterfNV(path, pname, value, l);
    }

    static native void nglPathParameterfNV(int var0, int var1, float var2, long var3);

    public static void glPathDashArrayNV(int path, FloatBuffer dashArray) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathDashArrayNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(dashArray);
        NVPathRendering.nglPathDashArrayNV(path, dashArray.remaining(), MemoryUtil.getAddress(dashArray), l);
    }

    static native void nglPathDashArrayNV(int var0, int var1, long var2, long var4);

    public static int glGenPathsNV(int range) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenPathsNV;
        BufferChecks.checkFunctionAddress(l);
        int n = NVPathRendering.nglGenPathsNV(range, l);
        return n;
    }

    static native int nglGenPathsNV(int var0, long var1);

    public static void glDeletePathsNV(int path, int range) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeletePathsNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglDeletePathsNV(path, range, l);
    }

    static native void nglDeletePathsNV(int var0, int var1, long var2);

    public static boolean glIsPathNV(int path) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsPathNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVPathRendering.nglIsPathNV(path, l);
        return bl;
    }

    static native boolean nglIsPathNV(int var0, long var1);

    public static void glPathStencilFuncNV(int func, int ref, int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathStencilFuncNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglPathStencilFuncNV(func, ref, mask, l);
    }

    static native void nglPathStencilFuncNV(int var0, int var1, int var2, long var3);

    public static void glPathStencilDepthOffsetNV(float factor, int units) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathStencilDepthOffsetNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglPathStencilDepthOffsetNV(factor, units, l);
    }

    static native void nglPathStencilDepthOffsetNV(float var0, int var1, long var2);

    public static void glStencilFillPathNV(int path, int fillMode, int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilFillPathNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglStencilFillPathNV(path, fillMode, mask, l);
    }

    static native void nglStencilFillPathNV(int var0, int var1, int var2, long var3);

    public static void glStencilStrokePathNV(int path, int reference, int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilStrokePathNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglStencilStrokePathNV(path, reference, mask, l);
    }

    static native void nglStencilStrokePathNV(int var0, int var1, int var2, long var3);

    public static void glStencilFillPathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int fillMode, int mask, int transformType, FloatBuffer transformValues) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilFillPathInstancedNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paths);
        if (transformValues != null) {
            BufferChecks.checkBuffer(transformValues, GLChecks.calculateTransformPathValues(transformType));
        }
        NVPathRendering.nglStencilFillPathInstancedNV(paths.remaining() / GLChecks.calculateBytesPerPathName(pathNameType), pathNameType, MemoryUtil.getAddress(paths), pathBase, fillMode, mask, transformType, MemoryUtil.getAddressSafe(transformValues), l);
    }

    static native void nglStencilFillPathInstancedNV(int var0, int var1, long var2, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glStencilStrokePathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int reference, int mask, int transformType, FloatBuffer transformValues) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilStrokePathInstancedNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paths);
        if (transformValues != null) {
            BufferChecks.checkBuffer(transformValues, GLChecks.calculateTransformPathValues(transformType));
        }
        NVPathRendering.nglStencilStrokePathInstancedNV(paths.remaining() / GLChecks.calculateBytesPerPathName(pathNameType), pathNameType, MemoryUtil.getAddress(paths), pathBase, reference, mask, transformType, MemoryUtil.getAddressSafe(transformValues), l);
    }

    static native void nglStencilStrokePathInstancedNV(int var0, int var1, long var2, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glPathCoverDepthFuncNV(int zfunc) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathCoverDepthFuncNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglPathCoverDepthFuncNV(zfunc, l);
    }

    static native void nglPathCoverDepthFuncNV(int var0, long var1);

    public static void glPathColorGenNV(int color, int genMode, int colorFormat, FloatBuffer coeffs) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathColorGenNV;
        BufferChecks.checkFunctionAddress(l);
        if (coeffs != null) {
            BufferChecks.checkBuffer(coeffs, GLChecks.calculatePathColorGenCoeffsCount(genMode, colorFormat));
        }
        NVPathRendering.nglPathColorGenNV(color, genMode, colorFormat, MemoryUtil.getAddressSafe(coeffs), l);
    }

    static native void nglPathColorGenNV(int var0, int var1, int var2, long var3, long var5);

    public static void glPathTexGenNV(int texCoordSet, int genMode, FloatBuffer coeffs) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathTexGenNV;
        BufferChecks.checkFunctionAddress(l);
        if (coeffs != null) {
            BufferChecks.checkDirect(coeffs);
        }
        NVPathRendering.nglPathTexGenNV(texCoordSet, genMode, GLChecks.calculatePathTextGenCoeffsPerComponent(coeffs, genMode), MemoryUtil.getAddressSafe(coeffs), l);
    }

    static native void nglPathTexGenNV(int var0, int var1, int var2, long var3, long var5);

    public static void glPathFogGenNV(int genMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPathFogGenNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglPathFogGenNV(genMode, l);
    }

    static native void nglPathFogGenNV(int var0, long var1);

    public static void glCoverFillPathNV(int path, int coverMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCoverFillPathNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglCoverFillPathNV(path, coverMode, l);
    }

    static native void nglCoverFillPathNV(int var0, int var1, long var2);

    public static void glCoverStrokePathNV(int name, int coverMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCoverStrokePathNV;
        BufferChecks.checkFunctionAddress(l);
        NVPathRendering.nglCoverStrokePathNV(name, coverMode, l);
    }

    static native void nglCoverStrokePathNV(int var0, int var1, long var2);

    public static void glCoverFillPathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int coverMode, int transformType, FloatBuffer transformValues) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCoverFillPathInstancedNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paths);
        if (transformValues != null) {
            BufferChecks.checkBuffer(transformValues, GLChecks.calculateTransformPathValues(transformType));
        }
        NVPathRendering.nglCoverFillPathInstancedNV(paths.remaining() / GLChecks.calculateBytesPerPathName(pathNameType), pathNameType, MemoryUtil.getAddress(paths), pathBase, coverMode, transformType, MemoryUtil.getAddressSafe(transformValues), l);
    }

    static native void nglCoverFillPathInstancedNV(int var0, int var1, long var2, int var4, int var5, int var6, long var7, long var9);

    public static void glCoverStrokePathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int coverMode, int transformType, FloatBuffer transformValues) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCoverStrokePathInstancedNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paths);
        if (transformValues != null) {
            BufferChecks.checkBuffer(transformValues, GLChecks.calculateTransformPathValues(transformType));
        }
        NVPathRendering.nglCoverStrokePathInstancedNV(paths.remaining() / GLChecks.calculateBytesPerPathName(pathNameType), pathNameType, MemoryUtil.getAddress(paths), pathBase, coverMode, transformType, MemoryUtil.getAddressSafe(transformValues), l);
    }

    static native void nglCoverStrokePathInstancedNV(int var0, int var1, long var2, int var4, int var5, int var6, long var7, long var9);

    public static void glGetPathParameterNV(int name, int param, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathParameterivNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 4);
        NVPathRendering.nglGetPathParameterivNV(name, param, MemoryUtil.getAddress(value), l);
    }

    static native void nglGetPathParameterivNV(int var0, int var1, long var2, long var4);

    public static int glGetPathParameteriNV(int name, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathParameterivNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVPathRendering.nglGetPathParameterivNV(name, param, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetPathParameterfvNV(int name, int param, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathParameterfvNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 4);
        NVPathRendering.nglGetPathParameterfvNV(name, param, MemoryUtil.getAddress(value), l);
    }

    static native void nglGetPathParameterfvNV(int var0, int var1, long var2, long var4);

    public static float glGetPathParameterfNV(int name, int param) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathParameterfvNV;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        NVPathRendering.nglGetPathParameterfvNV(name, param, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetPathCommandsNV(int name, ByteBuffer commands) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathCommandsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(commands);
        NVPathRendering.nglGetPathCommandsNV(name, MemoryUtil.getAddress(commands), l);
    }

    static native void nglGetPathCommandsNV(int var0, long var1, long var3);

    public static void glGetPathCoordsNV(int name, FloatBuffer coords) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathCoordsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(coords);
        NVPathRendering.nglGetPathCoordsNV(name, MemoryUtil.getAddress(coords), l);
    }

    static native void nglGetPathCoordsNV(int var0, long var1, long var3);

    public static void glGetPathDashArrayNV(int name, FloatBuffer dashArray) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathDashArrayNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(dashArray);
        NVPathRendering.nglGetPathDashArrayNV(name, MemoryUtil.getAddress(dashArray), l);
    }

    static native void nglGetPathDashArrayNV(int var0, long var1, long var3);

    public static void glGetPathMetricsNV(int metricQueryMask, int pathNameType, ByteBuffer paths, int pathBase, int stride, FloatBuffer metrics) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathMetricsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paths);
        BufferChecks.checkBuffer(metrics, GLChecks.calculateMetricsSize(metricQueryMask, stride));
        NVPathRendering.nglGetPathMetricsNV(metricQueryMask, paths.remaining() / GLChecks.calculateBytesPerPathName(pathNameType), pathNameType, MemoryUtil.getAddress(paths), pathBase, stride, MemoryUtil.getAddress(metrics), l);
    }

    static native void nglGetPathMetricsNV(int var0, int var1, int var2, long var3, int var5, int var6, long var7, long var9);

    public static void glGetPathMetricRangeNV(int metricQueryMask, int fistPathName, int numPaths, int stride, FloatBuffer metrics) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathMetricRangeNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(metrics, GLChecks.calculateMetricsSize(metricQueryMask, stride));
        NVPathRendering.nglGetPathMetricRangeNV(metricQueryMask, fistPathName, numPaths, stride, MemoryUtil.getAddress(metrics), l);
    }

    static native void nglGetPathMetricRangeNV(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetPathSpacingNV(int pathListMode, int pathNameType, ByteBuffer paths, int pathBase, float advanceScale, float kerningScale, int transformType, FloatBuffer returnedSpacing) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathSpacingNV;
        BufferChecks.checkFunctionAddress(l);
        int n = paths.remaining() / GLChecks.calculateBytesPerPathName(pathNameType);
        BufferChecks.checkDirect(paths);
        BufferChecks.checkBuffer(returnedSpacing, n - 1);
        NVPathRendering.nglGetPathSpacingNV(pathListMode, n, pathNameType, MemoryUtil.getAddress(paths), pathBase, advanceScale, kerningScale, transformType, MemoryUtil.getAddress(returnedSpacing), l);
    }

    static native void nglGetPathSpacingNV(int var0, int var1, int var2, long var3, int var5, float var6, float var7, int var8, long var9, long var11);

    public static void glGetPathColorGenNV(int color, int pname, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathColorGenivNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 16);
        NVPathRendering.nglGetPathColorGenivNV(color, pname, MemoryUtil.getAddress(value), l);
    }

    static native void nglGetPathColorGenivNV(int var0, int var1, long var2, long var4);

    public static int glGetPathColorGeniNV(int color, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathColorGenivNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVPathRendering.nglGetPathColorGenivNV(color, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetPathColorGenNV(int color, int pname, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathColorGenfvNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 16);
        NVPathRendering.nglGetPathColorGenfvNV(color, pname, MemoryUtil.getAddress(value), l);
    }

    static native void nglGetPathColorGenfvNV(int var0, int var1, long var2, long var4);

    public static float glGetPathColorGenfNV(int color, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathColorGenfvNV;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        NVPathRendering.nglGetPathColorGenfvNV(color, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static void glGetPathTexGenNV(int texCoordSet, int pname, IntBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathTexGenivNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 16);
        NVPathRendering.nglGetPathTexGenivNV(texCoordSet, pname, MemoryUtil.getAddress(value), l);
    }

    static native void nglGetPathTexGenivNV(int var0, int var1, long var2, long var4);

    public static int glGetPathTexGeniNV(int texCoordSet, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathTexGenivNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVPathRendering.nglGetPathTexGenivNV(texCoordSet, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetPathTexGenNV(int texCoordSet, int pname, FloatBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathTexGenfvNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(value, 16);
        NVPathRendering.nglGetPathTexGenfvNV(texCoordSet, pname, MemoryUtil.getAddress(value), l);
    }

    static native void nglGetPathTexGenfvNV(int var0, int var1, long var2, long var4);

    public static float glGetPathTexGenfNV(int texCoordSet, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathTexGenfvNV;
        BufferChecks.checkFunctionAddress(l);
        FloatBuffer floatBuffer = APIUtil.getBufferFloat(contextCapabilities);
        NVPathRendering.nglGetPathTexGenfvNV(texCoordSet, pname, MemoryUtil.getAddress(floatBuffer), l);
        return floatBuffer.get(0);
    }

    public static boolean glIsPointInFillPathNV(int path, int mask, float x, float y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsPointInFillPathNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVPathRendering.nglIsPointInFillPathNV(path, mask, x, y, l);
        return bl;
    }

    static native boolean nglIsPointInFillPathNV(int var0, int var1, float var2, float var3, long var4);

    public static boolean glIsPointInStrokePathNV(int path, float x, float y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsPointInStrokePathNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVPathRendering.nglIsPointInStrokePathNV(path, x, y, l);
        return bl;
    }

    static native boolean nglIsPointInStrokePathNV(int var0, float var1, float var2, long var3);

    public static float glGetPathLengthNV(int path, int startSegment, int numSegments) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetPathLengthNV;
        BufferChecks.checkFunctionAddress(l);
        float f = NVPathRendering.nglGetPathLengthNV(path, startSegment, numSegments, l);
        return f;
    }

    static native float nglGetPathLengthNV(int var0, int var1, int var2, long var3);

    public static boolean glPointAlongPathNV(int path, int startSegment, int numSegments, float distance, FloatBuffer x, FloatBuffer y, FloatBuffer tangentX, FloatBuffer tangentY) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glPointAlongPathNV;
        BufferChecks.checkFunctionAddress(l);
        if (x != null) {
            BufferChecks.checkBuffer(x, 1);
        }
        if (y != null) {
            BufferChecks.checkBuffer(y, 1);
        }
        if (tangentX != null) {
            BufferChecks.checkBuffer(tangentX, 1);
        }
        if (tangentY != null) {
            BufferChecks.checkBuffer(tangentY, 1);
        }
        boolean bl = NVPathRendering.nglPointAlongPathNV(path, startSegment, numSegments, distance, MemoryUtil.getAddressSafe(x), MemoryUtil.getAddressSafe(y), MemoryUtil.getAddressSafe(tangentX), MemoryUtil.getAddressSafe(tangentY), l);
        return bl;
    }

    static native boolean nglPointAlongPathNV(int var0, int var1, int var2, float var3, long var4, long var6, long var8, long var10, long var12);
}

