/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.LongBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.NVGpuShader5;

public final class NVShaderBufferLoad {
    public static final int GL_BUFFER_GPU_ADDRESS_NV = 36637;
    public static final int GL_GPU_ADDRESS_NV = 36660;
    public static final int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 36661;

    private NVShaderBufferLoad() {
    }

    public static void glMakeBufferResidentNV(int target, int access) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeBufferResidentNV;
        BufferChecks.checkFunctionAddress(l);
        NVShaderBufferLoad.nglMakeBufferResidentNV(target, access, l);
    }

    static native void nglMakeBufferResidentNV(int var0, int var1, long var2);

    public static void glMakeBufferNonResidentNV(int target) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeBufferNonResidentNV;
        BufferChecks.checkFunctionAddress(l);
        NVShaderBufferLoad.nglMakeBufferNonResidentNV(target, l);
    }

    static native void nglMakeBufferNonResidentNV(int var0, long var1);

    public static boolean glIsBufferResidentNV(int target) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsBufferResidentNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVShaderBufferLoad.nglIsBufferResidentNV(target, l);
        return bl;
    }

    static native boolean nglIsBufferResidentNV(int var0, long var1);

    public static void glMakeNamedBufferResidentNV(int buffer, int access) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeNamedBufferResidentNV;
        BufferChecks.checkFunctionAddress(l);
        NVShaderBufferLoad.nglMakeNamedBufferResidentNV(buffer, access, l);
    }

    static native void nglMakeNamedBufferResidentNV(int var0, int var1, long var2);

    public static void glMakeNamedBufferNonResidentNV(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMakeNamedBufferNonResidentNV;
        BufferChecks.checkFunctionAddress(l);
        NVShaderBufferLoad.nglMakeNamedBufferNonResidentNV(buffer, l);
    }

    static native void nglMakeNamedBufferNonResidentNV(int var0, long var1);

    public static boolean glIsNamedBufferResidentNV(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsNamedBufferResidentNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVShaderBufferLoad.nglIsNamedBufferResidentNV(buffer, l);
        return bl;
    }

    static native boolean nglIsNamedBufferResidentNV(int var0, long var1);

    public static void glGetBufferParameteruNV(int target, int pname, LongBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 1);
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetBufferParameterui64vNV(int var0, int var1, long var2, long var4);

    public static long glGetBufferParameterui64NV(int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.getAddress(longBuffer), l);
        return longBuffer.get(0);
    }

    public static void glGetNamedBufferParameteruNV(int buffer, int pname, LongBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 1);
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetNamedBufferParameterui64vNV(int var0, int var1, long var2, long var4);

    public static long glGetNamedBufferParameterui64NV(int buffer, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetNamedBufferParameterui64vNV;
        BufferChecks.checkFunctionAddress(l);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.getAddress(longBuffer), l);
        return longBuffer.get(0);
    }

    public static void glGetIntegeruNV(int value, LongBuffer result) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetIntegerui64vNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(result, 1);
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.getAddress(result), l);
    }

    static native void nglGetIntegerui64vNV(int var0, long var1, long var3);

    public static long glGetIntegerui64NV(int value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetIntegerui64vNV;
        BufferChecks.checkFunctionAddress(l);
        LongBuffer longBuffer = APIUtil.getBufferLong(contextCapabilities);
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.getAddress(longBuffer), l);
        return longBuffer.get(0);
    }

    public static void glUniformui64NV(int location, long value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformui64NV;
        BufferChecks.checkFunctionAddress(l);
        NVShaderBufferLoad.nglUniformui64NV(location, value, l);
    }

    static native void nglUniformui64NV(int var0, long var1, long var3);

    public static void glUniformuNV(int location, LongBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformui64vNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        NVShaderBufferLoad.nglUniformui64vNV(location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglUniformui64vNV(int var0, int var1, long var2, long var4);

    public static void glGetUniformuNV(int program, int location, LongBuffer params) {
        NVGpuShader5.glGetUniformuNV(program, location, params);
    }

    public static void glProgramUniformui64NV(int program, int location, long value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformui64NV;
        BufferChecks.checkFunctionAddress(l);
        NVShaderBufferLoad.nglProgramUniformui64NV(program, location, value, l);
    }

    static native void nglProgramUniformui64NV(int var0, int var1, long var2, long var4);

    public static void glProgramUniformuNV(int program, int location, LongBuffer value) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glProgramUniformui64vNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(value);
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, value.remaining(), MemoryUtil.getAddress(value), l);
    }

    static native void nglProgramUniformui64vNV(int var0, int var1, int var2, long var3, long var5);
}

