/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.Sys;
import org.lwjgl.opengl.Sync$1;
import org.lwjgl.opengl.Sync$RunningAvg;

class Sync {
    public static final long NANOS_IN_SECOND = 1000000000L;
    private static long nextFrame = 0L;
    private static boolean initialised = false;
    private static Sync$RunningAvg sleepDurations = new Sync$RunningAvg(10);
    private static Sync$RunningAvg yieldDurations = new Sync$RunningAvg(10);

    Sync() {
    }

    public static void sync(int fps) {
        if (fps <= 0) {
            return;
        }
        if (!initialised) {
            Sync.initialise();
        }
        try {
            long l;
            long l2 = Sync.getTime();
            while (nextFrame - l2 > sleepDurations.avg()) {
                Thread.sleep(1L);
                l = Sync.getTime();
                sleepDurations.add(l - l2);
                l2 = l;
            }
            sleepDurations.dampenForLowResTicker();
            l2 = Sync.getTime();
            while (nextFrame - l2 > yieldDurations.avg()) {
                Thread.yield();
                l = Sync.getTime();
                yieldDurations.add(l - l2);
                l2 = l;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        nextFrame = Math.max(nextFrame + 1000000000L / (long)fps, Sync.getTime());
    }

    private static void initialise() {
        initialised = true;
        sleepDurations.init(1000000L);
        yieldDurations.init((int)((double)(-(Sync.getTime() - Sync.getTime())) * 1.333));
        nextFrame = Sync.getTime();
        String string = System.getProperty("os.name");
        if (string.startsWith("Win")) {
            Thread thread = new Thread(new Sync$1());
            thread.setName("LWJGL Timer");
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static long getTime() {
        return Sys.getTime() * 1000000000L / Sys.getTimerResolution();
    }
}

