/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextGL;
import org.lwjgl.opengl.ContextImplementation;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.Util;

final class WindowsContextImplementation
implements ContextImplementation {
    WindowsContextImplementation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer create(PeerInfo peer_info, IntBuffer attribs, ByteBuffer shared_context_handle) {
        ByteBuffer byteBuffer = peer_info.lockAndGetHandle();
        try {
            ByteBuffer byteBuffer2 = WindowsContextImplementation.nCreate(byteBuffer, attribs, shared_context_handle);
            return byteBuffer2;
        }
        finally {
            peer_info.unlock();
        }
    }

    private static native ByteBuffer nCreate(ByteBuffer var0, IntBuffer var1, ByteBuffer var2);

    native long getHGLRC(ByteBuffer var1);

    native long getHDC(ByteBuffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        ContextGL contextGL = ContextGL.getCurrentContext();
        if (contextGL == null) {
            throw new IllegalStateException("No context is current");
        }
        ContextGL contextGL2 = contextGL;
        synchronized (contextGL2) {
            PeerInfo peerInfo = contextGL.getPeerInfo();
            ByteBuffer byteBuffer = peerInfo.lockAndGetHandle();
            try {
                WindowsContextImplementation.nSwapBuffers(byteBuffer);
            }
            finally {
                peerInfo.unlock();
            }
        }
    }

    private static native void nSwapBuffers(ByteBuffer var0);

    @Override
    public void releaseDrawable(ByteBuffer context_handle) {
    }

    @Override
    public void update(ByteBuffer context_handle) {
    }

    @Override
    public void releaseCurrentContext() {
        WindowsContextImplementation.nReleaseCurrentContext();
    }

    private static native void nReleaseCurrentContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent(PeerInfo peer_info, ByteBuffer handle) {
        ByteBuffer byteBuffer = peer_info.lockAndGetHandle();
        try {
            WindowsContextImplementation.nMakeCurrent(byteBuffer, handle);
        }
        finally {
            peer_info.unlock();
        }
    }

    private static native void nMakeCurrent(ByteBuffer var0, ByteBuffer var1);

    @Override
    public boolean isCurrent(ByteBuffer handle) {
        boolean bl = WindowsContextImplementation.nIsCurrent(handle);
        return bl;
    }

    private static native boolean nIsCurrent(ByteBuffer var0);

    @Override
    public void setSwapInterval(int value) {
        boolean bl = WindowsContextImplementation.nSetSwapInterval(value);
        if (!bl) {
            LWJGLUtil.log("Failed to set swap interval");
        }
        Util.checkGLError();
    }

    private static native boolean nSetSwapInterval(int var0);

    @Override
    public void destroy(PeerInfo peer_info, ByteBuffer handle) {
        WindowsContextImplementation.nDestroy(handle);
    }

    private static native void nDestroy(ByteBuffer var0);
}

