/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.LibraryJavaSound$Exception;
import paulscode.sound.libraries.LibraryJavaSound$MixerRanking;
import paulscode.sound.libraries.SourceJavaSound;

@ObfuscationIgnore
public class LibraryJavaSound
extends Library {
    @ObfuscationIgnore
    private static final boolean GET = false;
    @ObfuscationIgnore
    private static final boolean SET = true;
    @ObfuscationIgnore
    private static final int XXX = 0;
    @ObfuscationIgnore
    private final int maxClipSize = 0x100000;
    @ObfuscationIgnore
    private static Mixer myMixer = null;
    @ObfuscationIgnore
    private static LibraryJavaSound$MixerRanking myMixerRanking = null;
    @ObfuscationIgnore
    private static LibraryJavaSound instance = null;
    @ObfuscationIgnore
    private static int minSampleRate = 4000;
    @ObfuscationIgnore
    private static int maxSampleRate = 48000;
    @ObfuscationIgnore
    private static int lineCount = 32;
    @ObfuscationIgnore
    private static boolean useGainControl = true;
    @ObfuscationIgnore
    private static boolean usePanControl = true;
    @ObfuscationIgnore
    private static boolean useSampleRateControl = true;

    @ObfuscationIgnore
    public LibraryJavaSound() {
        instance = this;
    }

    /*
     * WARNING - void declaration
     */
    @ObfuscationIgnore
    public void init() {
        LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking = null;
        if (myMixer == null) {
            for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                if (!info.getName().equals("Java Sound Audio Engine")) continue;
                libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
                try {
                    libraryJavaSound$MixerRanking.rank(info);
                }
                catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                    break;
                }
                if (libraryJavaSound$MixerRanking.IIIiiiiiiiiiIiiiiiiIIIIiiiIiIIiiiiIiiiIIIiiiiIIIIiiIIiIiIiiIIIII < 14) break;
                myMixer = AudioSystem.getMixer(info);
                LibraryJavaSound.mixerRanking(true, libraryJavaSound$MixerRanking);
                break;
            }
            if (myMixer == null) {
                void var2_4;
                LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking2 = libraryJavaSound$MixerRanking;
                for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                    libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
                    try {
                        libraryJavaSound$MixerRanking.rank(info);
                    }
                    catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                        // empty catch block
                    }
                    if (var2_4 != null && libraryJavaSound$MixerRanking.IIIiiiiiiiiiIiiiiiiIIIIiiiIiIIiiiiIiiiIIIiiiiIIIIiiIIiIiIiiIIIII <= var2_4.IIIiiiiiiiiiIiiiiiiIIIIiiiIiIIiiiiIiiiIIIiiiiIIIIiiIIiIiIiiIIIII) continue;
                    LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking3 = libraryJavaSound$MixerRanking;
                }
                if (var2_4 == null) {
                    throw new LibraryJavaSound$Exception("No useable mixers found!", new LibraryJavaSound$MixerRanking());
                }
                try {
                    myMixer = AudioSystem.getMixer(var2_4.iIIIiIiIiiIiIiIIiIIIIIiiIIiIiiIiiiiiiIIiiIiiIiiIIiiIIIiiIIiIIIII);
                    LibraryJavaSound.mixerRanking(true, (LibraryJavaSound$MixerRanking)var2_4);
                }
                catch (Exception exception) {
                    throw new LibraryJavaSound$Exception("No useable mixers available!", new LibraryJavaSound$MixerRanking());
                }
            }
        }
        this.setMasterVolume(1.0f);
        this.message("JavaSound initialized.");
        super.init();
    }

    @ObfuscationIgnore
    public static boolean libraryCompatible() {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equals("Java Sound Audio Engine")) continue;
            return true;
        }
        return false;
    }

    @ObfuscationIgnore
    protected Channel createChannel(int type) {
        return new ChannelJavaSound(type, myMixer);
    }

    @ObfuscationIgnore
    public void cleanup() {
        super.cleanup();
        instance = null;
        myMixer = null;
        myMixerRanking = null;
    }

    @ObfuscationIgnore
    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec((String)filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (soundBuffer != null) {
            this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    @ObfuscationIgnore
    public boolean loadSound(SoundBuffer buffer, String identifier) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(identifier == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(identifier) != null) {
            return true;
        }
        if (buffer != null) {
            this.bufferMap.put(identifier, buffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    @ObfuscationIgnore
    public void setMasterVolume(float value) {
        super.setMasterVolume(value);
        Set set = this.sourceMap.keySet();
        for (String string : set) {
            Source source = (Source)this.sourceMap.get(string);
            if (source == null) continue;
            source.positionChanged();
        }
    }

    @ObfuscationIgnore
    public void newSource(boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, float x, float y, float z, int attModel, float distOrRoll) {
        SoundBuffer soundBuffer = null;
        if (!toStream) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + sourcename + "' was not created because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + sourcename + "' was not created because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!toStream && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(sourcename, new SourceJavaSound(this.listener, priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, false));
    }

    @ObfuscationIgnore
    public void rawDataStream(AudioFormat audioFormat, boolean priority, String sourcename, float x, float y, float z, int attModel, float distOrRoll) {
        this.sourceMap.put(sourcename, new SourceJavaSound(this.listener, audioFormat, priority, sourcename, x, y, z, attModel, distOrRoll));
    }

    @ObfuscationIgnore
    public void quickPlay(boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, float x, float y, float z, int attModel, float distOrRoll, boolean temporary) {
        SoundBuffer soundBuffer = null;
        if (!toStream) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + sourcename + "' was not created because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + sourcename + "' was not created because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!toStream && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(sourcename, new SourceJavaSound(this.listener, priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, temporary));
    }

    @ObfuscationIgnore
    public void copySources(HashMap<String, Source> srcMap) {
        if (srcMap == null) {
            return;
        }
        Set<String> set = srcMap.keySet();
        Iterator<String> iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Source source = srcMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer != null) {
                soundBuffer.trimData(0x100000);
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceJavaSound(this.listener, source, soundBuffer));
        }
    }

    @ObfuscationIgnore
    public void setListenerVelocity(float x, float y, float z) {
        super.setListenerVelocity(x, y, z);
        this.listenerMoved();
    }

    public void dopplerChanged() {
        super.dopplerChanged();
        this.listenerMoved();
    }

    public static Mixer IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii() {
        return LibraryJavaSound.mixer(false, null);
    }

    public static void IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(Mixer mixer) {
        LibraryJavaSound.mixer(true, mixer);
        SoundSystemException soundSystemException = SoundSystem.getLastException();
        SoundSystem.setException(null);
        if (soundSystemException != null) {
            throw soundSystemException;
        }
    }

    @ObfuscationIgnore
    private static synchronized Mixer mixer(boolean action, Mixer m) {
        if (action) {
            if (m == null) {
                return myMixer;
            }
            LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
            try {
                libraryJavaSound$MixerRanking.rank(m.getMixerInfo());
            }
            catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                SoundSystemConfig.getLogger().printStackTrace((Exception)((Object)libraryJavaSound$Exception), 1);
                SoundSystem.setException((SoundSystemException)libraryJavaSound$Exception);
            }
            myMixer = m;
            LibraryJavaSound.mixerRanking(true, libraryJavaSound$MixerRanking);
            if (instance != null) {
                ChannelJavaSound channelJavaSound;
                ListIterator listIterator = LibraryJavaSound.instance.normalChannels.listIterator();
                SoundSystem.setException(null);
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(m);
                }
                listIterator = LibraryJavaSound.instance.streamingChannels.listIterator();
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(m);
                }
            }
        }
        return myMixer;
    }

    @ObfuscationIgnore
    public static LibraryJavaSound$MixerRanking getMixerRanking() {
        return LibraryJavaSound.mixerRanking(false, null);
    }

    @ObfuscationIgnore
    private static synchronized LibraryJavaSound$MixerRanking mixerRanking(boolean action, LibraryJavaSound$MixerRanking value) {
        if (action) {
            myMixerRanking = value;
        }
        return myMixerRanking;
    }

    public static void IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(int n) {
        LibraryJavaSound.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(true, n);
    }

    private static synchronized int IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(boolean bl, int n) {
        if (bl) {
            minSampleRate = n;
        }
        return minSampleRate;
    }

    public static void iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(int n) {
        LibraryJavaSound.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI(true, n);
    }

    private static synchronized int iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI(boolean bl, int n) {
        if (bl) {
            maxSampleRate = n;
        }
        return maxSampleRate;
    }

    public static void IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI(int n) {
        LibraryJavaSound.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII(true, n);
    }

    private static synchronized int iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII(boolean bl, int n) {
        if (bl) {
            lineCount = n;
        }
        return lineCount;
    }

    public static void IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(boolean bl) {
        LibraryJavaSound.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(true, bl);
    }

    private static synchronized boolean IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(boolean bl, boolean bl2) {
        if (bl) {
            useGainControl = bl2;
        }
        return useGainControl;
    }

    public static void iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(boolean bl) {
        LibraryJavaSound.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI(true, bl);
    }

    private static synchronized boolean iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI(boolean bl, boolean bl2) {
        if (bl) {
            usePanControl = bl2;
        }
        return usePanControl;
    }

    public static void IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI(boolean bl) {
        LibraryJavaSound.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII(true, bl);
    }

    private static synchronized boolean iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII(boolean bl, boolean bl2) {
        if (bl) {
            useSampleRateControl = bl2;
        }
        return useSampleRateControl;
    }

    @ObfuscationIgnore
    public static String getTitle() {
        return "Java Sound";
    }

    public static String iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI() {
        return "The Java Sound API.  For more information, see http://java.sun.com/products/java-media/sound/";
    }

    @ObfuscationIgnore
    public String getClassName() {
        return "LibraryJavaSound";
    }

    static /* synthetic */ int IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(boolean bl, int n) {
        return LibraryJavaSound.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(bl, n);
    }

    static /* synthetic */ int iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(boolean bl, int n) {
        return LibraryJavaSound.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI(bl, n);
    }

    static /* synthetic */ int IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI(boolean bl, int n) {
        return LibraryJavaSound.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII(bl, n);
    }

    static /* synthetic */ boolean IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(boolean bl, boolean bl2) {
        return LibraryJavaSound.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(bl, bl2);
    }

    static /* synthetic */ boolean iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(boolean bl, boolean bl2) {
        return LibraryJavaSound.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI(bl, bl2);
    }

    static /* synthetic */ boolean IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI(boolean bl, boolean bl2) {
        return LibraryJavaSound.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII(bl, bl2);
    }
}

