/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import fgm.IiIiIIIIiIiIIiiIiiIiIIiIiIiiIIIIIIiiIiiiIIiIiiIIiIIiiIiIIiIIiiII;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelLWJGLOpenAL;
import paulscode.sound.libraries.LibraryLWJGLOpenAL$Exception;
import paulscode.sound.libraries.SourceLWJGLOpenAL;

@ObfuscationIgnore
public class LibraryLWJGLOpenAL
extends Library {
    private static final boolean IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii = false;
    private static final boolean iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI = true;
    private static final boolean IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI = false;
    private FloatBuffer IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII = null;
    private FloatBuffer iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI = null;
    private FloatBuffer iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII = null;
    private HashMap<String, IntBuffer> IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii = new HashMap();
    private static boolean iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi = true;

    @ObfuscationIgnore
    public LibraryLWJGLOpenAL() {
        this.reverseByteOrder = true;
    }

    @ObfuscationIgnore
    public void init() {
        boolean bl = false;
        try {
            AL.create();
            bl = this.checkALError();
        }
        catch (LWJGLException lWJGLException) {
            this.errorMessage("Unable to initialize OpenAL.  Probable cause: OpenAL not supported.");
            this.printStackTrace(lWJGLException);
            throw new LibraryLWJGLOpenAL$Exception(lWJGLException.getMessage(), 101);
        }
        if (bl) {
            this.importantMessage("OpenAL did not initialize properly!");
        } else {
            this.message("OpenAL initialized.");
        }
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII = BufferUtils.createFloatBuffer(3).put(new float[]{this.listener.position.x, this.listener.position.y, this.listener.position.z});
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI = BufferUtils.createFloatBuffer(6).put(new float[]{this.listener.lookAt.x, this.listener.lookAt.y, this.listener.lookAt.z, this.listener.up.x, this.listener.up.y, this.listener.up.z});
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII = BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f});
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.flip();
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.flip();
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.flip();
        AL10.alListener(4100, this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII);
        bl = this.checkALError() || bl;
        AL10.alListener(4111, this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI);
        bl = this.checkALError() || bl;
        AL10.alListener(4102, this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII);
        bl = this.checkALError() || bl;
        AL10.alDopplerFactor(SoundSystemConfig.getDopplerFactor());
        bl = this.checkALError() || bl;
        AL10.alDopplerVelocity(SoundSystemConfig.getDopplerVelocity());
        boolean bl2 = bl = this.checkALError() || bl;
        if (bl) {
            this.importantMessage("OpenAL did not initialize properly!");
            throw new LibraryLWJGLOpenAL$Exception("Problem encountered while loading OpenAL or creating the listener.  Probable cause:  OpenAL not supported", 101);
        }
        super.init();
        ChannelLWJGLOpenAL channelLWJGLOpenAL = (ChannelLWJGLOpenAL)this.normalChannels.get(1);
        try {
            AL10.alSourcef(channelLWJGLOpenAL.ALSource.get(0), 4099, 1.0f);
            if (this.checkALError()) {
                LibraryLWJGLOpenAL.alPitchSupported(true, false);
                throw new LibraryLWJGLOpenAL$Exception("OpenAL: AL_PITCH not supported.", 108);
            }
            LibraryLWJGLOpenAL.alPitchSupported(true, true);
        }
        catch (Exception exception) {
            LibraryLWJGLOpenAL.alPitchSupported(true, false);
            throw new LibraryLWJGLOpenAL$Exception("OpenAL: AL_PITCH not supported.", 108);
        }
    }

    @ObfuscationIgnore
    public static boolean libraryCompatible() {
        if (AL.isCreated()) {
            return true;
        }
        try {
            AL.create();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            AL.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @ObfuscationIgnore
    protected Channel createChannel(int type) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        try {
            AL10.alGenSources(intBuffer);
        }
        catch (Exception exception) {
            AL10.alGetError();
            return null;
        }
        if (AL10.alGetError() != 0) {
            return null;
        }
        ChannelLWJGLOpenAL channelLWJGLOpenAL = new ChannelLWJGLOpenAL(type, intBuffer);
        return channelLWJGLOpenAL;
    }

    @ObfuscationIgnore
    public void cleanup() {
        super.cleanup();
        Set set = this.bufferMap.keySet();
        for (String string : set) {
            IntBuffer intBuffer = this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.get(string);
            if (intBuffer == null) continue;
            AL10.alDeleteBuffers(intBuffer);
            this.checkALError();
            intBuffer.clear();
        }
        this.bufferMap.clear();
        AL.destroy();
        this.bufferMap = null;
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII = null;
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI = null;
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ObfuscationIgnore
    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii == null) {
            this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii = new HashMap();
            this.importantMessage("Open AL Buffer Map was null in method'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec((String)filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.reverseByteOrder(true);
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (this.errorCheck(soundBuffer == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        soundBuffer = IiIiIIIIiIiIIiiIiiIiIIiIiIiiIIIIIIiiIiiiIIiIiiIIiIIiiIiIIiIIiiII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(soundBuffer, filenameURL.getFilename());
        this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        AudioFormat audioFormat = soundBuffer.audioFormat;
        int n = 0;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 4352;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n = 4353;
            }
        } else {
            if (audioFormat.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 4354;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        AL10.alGenBuffers(intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when loading " + filenameURL.getFilename())) {
            return false;
        }
        AL10.alBufferData(intBuffer.get(0), n, (ByteBuffer)BufferUtils.createByteBuffer(soundBuffer.audioData.length).put(soundBuffer.audioData).flip(), (int)audioFormat.getSampleRate());
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when loading " + filenameURL.getFilename()) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + filenameURL.getFilename())) {
            return false;
        }
        this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.put(filenameURL.getFilename(), intBuffer);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ObfuscationIgnore
    public boolean loadSound(SoundBuffer buffer, String identifier) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii == null) {
            this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii = new HashMap();
            this.importantMessage("Open AL Buffer Map was null in method'loadSound'");
        }
        if (this.errorCheck(identifier == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(identifier) != null) {
            return true;
        }
        if (this.errorCheck(buffer == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(identifier, buffer);
        AudioFormat audioFormat = buffer.audioFormat;
        int n = 0;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 4352;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n = 4353;
            }
        } else {
            if (audioFormat.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 4354;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        AL10.alGenBuffers(intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when saving " + identifier)) {
            return false;
        }
        AL10.alBufferData(intBuffer.get(0), n, (ByteBuffer)BufferUtils.createByteBuffer(buffer.audioData.length).put(buffer.audioData).flip(), (int)audioFormat.getSampleRate());
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when saving " + identifier) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + identifier)) {
            return false;
        }
        this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.put(identifier, intBuffer);
        return true;
    }

    @ObfuscationIgnore
    public void unloadSound(String filename) {
        this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.remove(filename);
        super.unloadSound(filename);
    }

    @ObfuscationIgnore
    public void setMasterVolume(float value) {
        super.setMasterVolume(value);
        AL10.alListenerf(4106, value);
        this.checkALError();
    }

    @ObfuscationIgnore
    public void newSource(boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, float x, float y, float z, int attModel, float distOrRoll) {
        IntBuffer intBuffer = null;
        if (!toStream) {
            intBuffer = this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.get(filenameURL.getFilename());
            if (intBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + sourcename + "' was not created because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            intBuffer = this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.errorMessage("Source '" + sourcename + "' was not created because a sound buffer was not found for " + filenameURL.getFilename());
                return;
            }
        }
        SoundBuffer soundBuffer = null;
        if (!toStream) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + sourcename + "' was not created because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + sourcename + "' was not created because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        this.sourceMap.put(sourcename, new SourceLWJGLOpenAL(this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII, intBuffer, priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, false));
        IiIiIIIIiIiIIiiIiiIiIIiIiIiiIIIIIIiiIiiiIIiIiiIIiIIiiIiIIiIIiiII.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII = attModel;
        IiIiIIIIiIiIIiiIiiIiIIiIiIiiIIIIIIiiIiiiIIiIiiIIiIIiiIiIIiIIiiII.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI = distOrRoll;
    }

    @ObfuscationIgnore
    public void rawDataStream(AudioFormat audioFormat, boolean priority, String sourcename, float x, float y, float z, int attModel, float distOrRoll) {
        this.sourceMap.put(sourcename, new SourceLWJGLOpenAL(this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII, audioFormat, priority, sourcename, x, y, z, attModel, distOrRoll));
    }

    @ObfuscationIgnore
    public void quickPlay(boolean priority, boolean toStream, boolean toLoop, String sourcename, FilenameURL filenameURL, float x, float y, float z, int attModel, float distOrRoll, boolean temporary) {
        IntBuffer intBuffer = null;
        if (!toStream) {
            intBuffer = this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.loadSound(filenameURL);
            }
            if ((intBuffer = this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.get(filenameURL.getFilename())) == null) {
                this.errorMessage("Sound buffer was not created for " + filenameURL.getFilename());
                return;
            }
        }
        SoundBuffer soundBuffer = null;
        if (!toStream) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + sourcename + "' was not created because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + sourcename + "' was not created because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        SourceLWJGLOpenAL sourceLWJGLOpenAL = new SourceLWJGLOpenAL(this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII, intBuffer, priority, toStream, toLoop, sourcename, filenameURL, soundBuffer, x, y, z, attModel, distOrRoll, false);
        this.sourceMap.put(sourcename, sourceLWJGLOpenAL);
        this.play(sourceLWJGLOpenAL);
        if (temporary) {
            sourceLWJGLOpenAL.setTemporary(true);
        }
    }

    @ObfuscationIgnore
    public void copySources(HashMap<String, Source> srcMap) {
        if (srcMap == null) {
            return;
        }
        Set<String> set = srcMap.keySet();
        Iterator<String> iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        if (this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii == null) {
            this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii = new HashMap();
            this.importantMessage("Open AL Buffer Map was null in method'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Source source = srcMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceLWJGLOpenAL(this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII, this.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii.get(source.filenameURL.getFilename()), source, soundBuffer));
        }
    }

    @ObfuscationIgnore
    public void setListenerPosition(float x, float y, float z) {
        super.setListenerPosition(x, y, z);
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.put(0, x);
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.put(1, y);
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.put(2, z);
        AL10.alListener(4100, this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII);
        this.checkALError();
    }

    @ObfuscationIgnore
    public void setListenerAngle(float angle) {
        super.setListenerAngle(angle);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(0, this.listener.lookAt.x);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(2, this.listener.lookAt.z);
        AL10.alListener(4111, this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI);
        this.checkALError();
    }

    @ObfuscationIgnore
    public void setListenerOrientation(float lookX, float lookY, float lookZ, float upX, float upY, float upZ) {
        super.setListenerOrientation(lookX, lookY, lookZ, upX, upY, upZ);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(0, lookX);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(1, lookY);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(2, lookZ);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(3, upX);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(4, upY);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(5, upZ);
        AL10.alListener(4111, this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI);
        this.checkALError();
    }

    @ObfuscationIgnore
    public void setListenerData(ListenerData l) {
        super.setListenerData(l);
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.put(0, l.position.x);
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.put(1, l.position.y);
        this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII.put(2, l.position.z);
        AL10.alListener(4100, this.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII);
        this.checkALError();
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(0, l.lookAt.x);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(1, l.lookAt.y);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(2, l.lookAt.z);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(3, l.up.x);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(4, l.up.y);
        this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI.put(5, l.up.z);
        AL10.alListener(4111, this.iIIiIIIiiIIiiiiIIiIiiiiiIIiIIiIiIIIIiIIiiIIiiiIIIiiiIIIiIIIiIiiI);
        this.checkALError();
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.put(0, l.velocity.x);
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.put(1, l.velocity.y);
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.put(2, l.velocity.z);
        AL10.alListener(4102, this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII);
        this.checkALError();
    }

    @ObfuscationIgnore
    public void setListenerVelocity(float x, float y, float z) {
        super.setListenerVelocity(x, y, z);
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.put(0, this.listener.velocity.x);
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.put(1, this.listener.velocity.y);
        this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII.put(2, this.listener.velocity.z);
        AL10.alListener(4102, this.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII);
    }

    @ObfuscationIgnore
    public void dopplerChanged() {
        super.dopplerChanged();
        AL10.alDopplerFactor(SoundSystemConfig.getDopplerFactor());
        this.checkALError();
        AL10.alDopplerVelocity(SoundSystemConfig.getDopplerVelocity());
        this.checkALError();
    }

    @ObfuscationIgnore
    private boolean checkALError() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter.");
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter.");
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value.");
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call.");
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory.");
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred.");
        return true;
    }

    @ObfuscationIgnore
    public static boolean alPitchSupported() {
        return LibraryLWJGLOpenAL.alPitchSupported(false, false);
    }

    @ObfuscationIgnore
    private static synchronized boolean alPitchSupported(boolean action, boolean value) {
        if (action) {
            iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi = value;
        }
        return iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi;
    }

    @ObfuscationIgnore
    public static String getTitle() {
        return "LWJGL OpenAL";
    }

    @ObfuscationIgnore
    public static String getDescription() {
        return "The LWJGL binding of OpenAL.  For more information, see http://www.lwjgl.org";
    }

    @ObfuscationIgnore
    public String getClassName() {
        return "LibraryLWJGLOpenAL";
    }
}

