/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.Cache$CacheResponseBody;
import okhttp3.Cache$Entry$Companion;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Request$Builder;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.TlsVersion;
import okhttp3.internal.cache.DiskLruCache$Editor;
import okhttp3.internal.cache.DiskLruCache$Snapshot;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ByteString$Companion;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010$\u001a\u00060%R\u00020&J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0012\u0010,\u001a\u00020(2\n\u0010-\u001a\u00060.R\u00020&R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lokhttp3/Cache$Entry;", "", "rawSource", "Lokio/Source;", "(Lokio/Source;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "code", "", "handshake", "Lokhttp3/Handshake;", "isHttps", "", "()Z", "message", "", "protocol", "Lokhttp3/Protocol;", "receivedResponseMillis", "", "requestMethod", "responseHeaders", "Lokhttp3/Headers;", "sentRequestMillis", "url", "Lokhttp3/HttpUrl;", "varyHeaders", "matches", "request", "Lokhttp3/Request;", "readCertificateList", "", "Ljava/security/cert/Certificate;", "source", "Lokio/BufferedSource;", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Lokhttp3/internal/cache/DiskLruCache;", "writeCertList", "", "sink", "Lokio/BufferedSink;", "certificates", "writeTo", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Companion", "okhttp"})
final class Cache$Entry {
    @NotNull
    public static final Cache$Entry$Companion Companion = new Cache$Entry$Companion(null);
    @NotNull
    private final HttpUrl url;
    @NotNull
    private final Headers varyHeaders;
    @NotNull
    private final String requestMethod;
    @NotNull
    private final Protocol protocol;
    private final int code;
    @NotNull
    private final String message;
    @NotNull
    private final Headers responseHeaders;
    @Nullable
    private final Handshake handshake;
    private final long sentRequestMillis;
    private final long receivedResponseMillis;
    @NotNull
    private static final String SENT_MILLIS = Platform.Companion.get().getPrefix() + "-Sent-Millis";
    @NotNull
    private static final String RECEIVED_MILLIS = Platform.Companion.get().getPrefix() + "-Received-Millis";

    private final boolean isHttps() {
        return Intrinsics.areEqual(this.url.scheme(), "https");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache$Entry(@NotNull Source source2) {
        Intrinsics.checkNotNullParameter(source2, "rawSource");
        Closeable closeable = source2;
        Throwable throwable = null;
        try {
            Object object = (Source)closeable;
            boolean bl = false;
            BufferedSource bufferedSource = Okio.buffer(source2);
            String string = bufferedSource.readUtf8LineStrict();
            HttpUrl httpUrl = HttpUrl.Companion.parse(string);
            if (httpUrl == null) {
                IOException iOException;
                IOException iOException2 = iOException = new IOException("Cache corruption for " + string);
                Cache$Entry cache$Entry = this;
                boolean bl2 = false;
                Platform.Companion.get().log("cache corruption", 5, iOException2);
                Cache$Entry cache$Entry2 = cache$Entry;
                throw (Throwable)iOException;
            }
            this.url = httpUrl;
            this.requestMethod = bufferedSource.readUtf8LineStrict();
            Headers$Builder headers$Builder = new Headers$Builder();
            int n = Cache.Companion.readInt$okhttp(bufferedSource);
            for (int i = 0; i < n; ++i) {
                headers$Builder.addLenient$okhttp(bufferedSource.readUtf8LineStrict());
            }
            this.varyHeaders = headers$Builder.build();
            StatusLine statusLine = StatusLine.Companion.parse(bufferedSource.readUtf8LineStrict());
            this.protocol = statusLine.protocol;
            this.code = statusLine.code;
            this.message = statusLine.message;
            Headers$Builder headers$Builder2 = new Headers$Builder();
            int n2 = Cache.Companion.readInt$okhttp(bufferedSource);
            for (int i = 0; i < n2; ++i) {
                headers$Builder2.addLenient$okhttp(bufferedSource.readUtf8LineStrict());
            }
            String string2 = headers$Builder2.get(SENT_MILLIS);
            String string3 = headers$Builder2.get(RECEIVED_MILLIS);
            headers$Builder2.removeAll(SENT_MILLIS);
            headers$Builder2.removeAll(RECEIVED_MILLIS);
            String string4 = string2;
            this.sentRequestMillis = string4 != null ? Long.parseLong(string4) : 0L;
            String string5 = string3;
            this.receivedResponseMillis = string5 != null ? Long.parseLong(string5) : 0L;
            this.responseHeaders = headers$Builder2.build();
            if (this.isHttps()) {
                String string6 = bufferedSource.readUtf8LineStrict();
                if (((CharSequence)string6).length() > 0) {
                    throw new IOException("expected \"\" but was \"" + string6 + '\"');
                }
                String string7 = bufferedSource.readUtf8LineStrict();
                CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(string7);
                List<Certificate> list = this.readCertificateList(bufferedSource);
                List<Certificate> list2 = this.readCertificateList(bufferedSource);
                TlsVersion tlsVersion = !bufferedSource.exhausted() ? TlsVersion.Companion.forJavaName(bufferedSource.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                this.handshake = Handshake.Companion.get(tlsVersion, cipherSuite, list, list2);
            } else {
                this.handshake = null;
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public Cache$Entry(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        this.url = response.request().url();
        this.varyHeaders = Cache.Companion.varyHeaders(response);
        this.requestMethod = response.request().method();
        this.protocol = response.protocol();
        this.code = response.code();
        this.message = response.message();
        this.responseHeaders = response.headers();
        this.handshake = response.handshake();
        this.sentRequestMillis = response.sentRequestAtMillis();
        this.receivedResponseMillis = response.receivedResponseAtMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(@NotNull DiskLruCache$Editor diskLruCache$Editor) {
        Intrinsics.checkNotNullParameter(diskLruCache$Editor, "editor");
        Closeable closeable = Okio.buffer(diskLruCache$Editor.newSink(0));
        Throwable throwable = null;
        try {
            int n;
            Object object = (BufferedSink)closeable;
            boolean bl = false;
            object.writeUtf8(this.url.toString()).writeByte(10);
            object.writeUtf8(this.requestMethod).writeByte(10);
            object.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n2 = this.varyHeaders.size();
            for (n = 0; n < n2; ++n) {
                object.writeUtf8(this.varyHeaders.name(n)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(n)).writeByte(10);
            }
            object.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            object.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n2 = this.responseHeaders.size();
            for (n = 0; n < n2; ++n) {
                object.writeUtf8(this.responseHeaders.name(n)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(n)).writeByte(10);
            }
            object.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            object.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                object.writeByte(10);
                Handshake handshake2 = this.handshake;
                Intrinsics.checkNotNull(handshake2);
                object.writeUtf8(handshake2.cipherSuite().javaName()).writeByte(10);
                this.writeCertList((BufferedSink)object, this.handshake.peerCertificates());
                this.writeCertList((BufferedSink)object, this.handshake.localCertificates());
                object.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final List<Certificate> readCertificateList(BufferedSource bufferedSource) {
        int n = Cache.Companion.readInt$okhttp(bufferedSource);
        if (n == -1) {
            return CollectionsKt.emptyList();
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n);
            for (int i = 0; i < n; ++i) {
                ByteString byteString;
                String string = bufferedSource.readUtf8LineStrict();
                Buffer buffer = new Buffer();
                if (ByteString.Companion.decodeBase64(string) == null) {
                    throw new IOException("Corrupt certificate in cache entry");
                }
                buffer.write(byteString);
                arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
            }
            return arrayList;
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException.getMessage());
        }
    }

    private final void writeCertList(BufferedSink bufferedSink, List<? extends Certificate> list) {
        try {
            bufferedSink.writeDecimalLong(list.size()).writeByte(10);
            for (Certificate certificate : list) {
                byte[] byArray = certificate.getEncoded();
                Intrinsics.checkNotNullExpressionValue(byArray, "bytes");
                String string = ByteString$Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).base64();
                bufferedSink.writeUtf8(string).writeByte(10);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(certificateEncodingException.getMessage());
        }
    }

    public final boolean matches(@NotNull Request request, @NotNull Response response) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(response, "response");
        return Intrinsics.areEqual(this.url, request.url()) && Intrinsics.areEqual(this.requestMethod, request.method()) && Cache.Companion.varyMatches(response, this.varyHeaders, request);
    }

    @NotNull
    public final Response response(@NotNull DiskLruCache$Snapshot diskLruCache$Snapshot) {
        Intrinsics.checkNotNullParameter(diskLruCache$Snapshot, "snapshot");
        String string = this.responseHeaders.get("Content-Type");
        String string2 = this.responseHeaders.get("Content-Length");
        Request request = new Request$Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
        return new Response$Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new Cache$CacheResponseBody(diskLruCache$Snapshot, string, string2)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
    }
}

