/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.cache.DiskLruCache$Editor;
import okhttp3.internal.cache.DiskLruCache$Entry$newSource$1;
import okhttp3.internal.cache.DiskLruCache$Snapshot;
import okio.BufferedSink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001aH\u0002J\u001b\u00105\u001a\u0002062\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301H\u0000\u00a2\u0006\u0002\b7J\u0013\u00108\u001a\b\u0018\u000109R\u00020\fH\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0018\u00010\u000bR\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$\u00a8\u0006?"}, d2={"Lokhttp3/internal/cache/DiskLruCache$Entry;", "", "key", "", "(Lokhttp3/internal/cache/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "", "Ljava/io/File;", "getCleanFiles$okhttp", "()Ljava/util/List;", "currentEditor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Lokhttp3/internal/cache/DiskLruCache;", "getCurrentEditor$okhttp", "()Lokhttp3/internal/cache/DiskLruCache$Editor;", "setCurrentEditor$okhttp", "(Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles$okhttp", "getKey$okhttp", "()Ljava/lang/String;", "lengths", "", "getLengths$okhttp", "()[J", "lockingSourceCount", "", "getLockingSourceCount$okhttp", "()I", "setLockingSourceCount$okhttp", "(I)V", "readable", "", "getReadable$okhttp", "()Z", "setReadable$okhttp", "(Z)V", "sequenceNumber", "", "getSequenceNumber$okhttp", "()J", "setSequenceNumber$okhttp", "(J)V", "zombie", "getZombie$okhttp", "setZombie$okhttp", "invalidLengths", "", "strings", "", "newSource", "Lokio/Source;", "index", "setLengths", "", "setLengths$okhttp", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "snapshot$okhttp", "writeLengths", "writer", "Lokio/BufferedSink;", "writeLengths$okhttp", "okhttp"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache$Entry\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1065:1\n608#2,4:1066\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache$Entry\n*L\n1001#1:1066,4\n*E\n"})
public final class DiskLruCache$Entry {
    @NotNull
    private final String key;
    @NotNull
    private final long[] lengths;
    @NotNull
    private final List<File> cleanFiles;
    @NotNull
    private final List<File> dirtyFiles;
    private boolean readable;
    private boolean zombie;
    @Nullable
    private DiskLruCache$Editor currentEditor;
    private int lockingSourceCount;
    private long sequenceNumber;
    final /* synthetic */ DiskLruCache this$0;

    public DiskLruCache$Entry(@NotNull DiskLruCache diskLruCache, String string) {
        Intrinsics.checkNotNullParameter(string, "key");
        this.this$0 = diskLruCache;
        this.key = string;
        this.lengths = new long[this.this$0.getValueCount$okhttp()];
        this.cleanFiles = new ArrayList();
        this.dirtyFiles = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder(this.key).append('.');
        int n = stringBuilder.length();
        int n2 = this.this$0.getValueCount$okhttp();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(i);
            ((Collection)this.cleanFiles).add(new File(this.this$0.getDirectory(), stringBuilder.toString()));
            stringBuilder.append(".tmp");
            ((Collection)this.dirtyFiles).add(new File(this.this$0.getDirectory(), stringBuilder.toString()));
            stringBuilder.setLength(n);
        }
    }

    @NotNull
    public final String getKey$okhttp() {
        return this.key;
    }

    @NotNull
    public final long[] getLengths$okhttp() {
        return this.lengths;
    }

    @NotNull
    public final List<File> getCleanFiles$okhttp() {
        return this.cleanFiles;
    }

    @NotNull
    public final List<File> getDirtyFiles$okhttp() {
        return this.dirtyFiles;
    }

    public final boolean getReadable$okhttp() {
        return this.readable;
    }

    public final void setReadable$okhttp(boolean bl) {
        this.readable = bl;
    }

    public final boolean getZombie$okhttp() {
        return this.zombie;
    }

    public final void setZombie$okhttp(boolean bl) {
        this.zombie = bl;
    }

    @Nullable
    public final DiskLruCache$Editor getCurrentEditor$okhttp() {
        return this.currentEditor;
    }

    public final void setCurrentEditor$okhttp(@Nullable DiskLruCache$Editor diskLruCache$Editor) {
        this.currentEditor = diskLruCache$Editor;
    }

    public final int getLockingSourceCount$okhttp() {
        return this.lockingSourceCount;
    }

    public final void setLockingSourceCount$okhttp(int n) {
        this.lockingSourceCount = n;
    }

    public final long getSequenceNumber$okhttp() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber$okhttp(long l) {
        this.sequenceNumber = l;
    }

    public final void setLengths$okhttp(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "strings");
        if (list.size() != this.this$0.getValueCount$okhttp()) {
            this.invalidLengths(list);
            throw new KotlinNothingValueException();
        }
        try {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.lengths[i] = Long.parseLong(list.get(i));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidLengths(list);
            throw new KotlinNothingValueException();
        }
    }

    public final void writeLengths$okhttp(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter(bufferedSink, "writer");
        for (long l : this.lengths) {
            bufferedSink.writeByte(32).writeDecimalLong(l);
        }
    }

    private final Void invalidLengths(List<String> list) {
        throw new IOException("unexpected journal line: " + list);
    }

    @Nullable
    public final DiskLruCache$Snapshot snapshot$okhttp() {
        Object object = this.this$0;
        boolean bl = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(object)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object));
        }
        if (!this.readable) {
            return null;
        }
        if (!DiskLruCache.access$getCivilizedFileSystem$p(this.this$0) && (this.currentEditor != null || this.zombie)) {
            return null;
        }
        object = new ArrayList();
        long[] lArray = (long[])this.lengths.clone();
        try {
            int n = this.this$0.getValueCount$okhttp();
            for (int i = 0; i < n; ++i) {
                ((Collection)object).add(this.newSource(i));
            }
            return new DiskLruCache$Snapshot(this.this$0, this.key, this.sequenceNumber, (List<? extends Source>)object, lArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Source source2 = (Source)iterator2.next();
                Util.closeQuietly(source2);
            }
            try {
                this.this$0.removeEntry$okhttp(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private final Source newSource(int n) {
        Source source2 = this.this$0.getFileSystem$okhttp().source(this.cleanFiles.get(n));
        if (DiskLruCache.access$getCivilizedFileSystem$p(this.this$0)) {
            return source2;
        }
        int n2 = this.lockingSourceCount;
        this.lockingSourceCount = n2 + 1;
        return new DiskLruCache$Entry$newSource$1(source2, this.this$0, this);
    }
}

