/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.Segment;
import okio.SegmentPool;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lokio/Buffer$UnsafeCursor;", "Ljava/io/Closeable;", "()V", "buffer", "Lokio/Buffer;", "data", "", "end", "", "offset", "", "readWrite", "", "segment", "Lokio/Segment;", "getSegment$okio", "()Lokio/Segment;", "setSegment$okio", "(Lokio/Segment;)V", "start", "close", "", "expandBuffer", "minByteCount", "next", "resizeBuffer", "newSize", "seek", "okio"})
@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nokio/Buffer$UnsafeCursor\n+ 2 Buffer.kt\nokio/internal/-Buffer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,641:1\n1567#2:642\n1568#2:644\n1572#2:645\n1573#2,68:647\n1644#2:715\n1645#2,32:717\n1677#2,18:750\n1698#2:768\n1699#2,18:770\n1721#2:788\n1723#2,7:790\n1#3:643\n1#3:646\n1#3:716\n1#3:769\n1#3:789\n86#4:749\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nokio/Buffer$UnsafeCursor\n*L\n628#1:642\n628#1:644\n630#1:645\n630#1:647,68\n632#1:715\n632#1:717,32\n632#1:750,18\n634#1:768\n634#1:770,18\n637#1:788\n637#1:790,7\n628#1:643\n630#1:646\n632#1:716\n634#1:769\n637#1:789\n632#1:749\n*E\n"})
public final class Buffer$UnsafeCursor
implements Closeable {
    @JvmField
    @Nullable
    public Buffer buffer;
    @JvmField
    public boolean readWrite;
    @Nullable
    private Segment segment;
    @JvmField
    public long offset = -1L;
    @JvmField
    @Nullable
    public byte[] data;
    @JvmField
    public int start = -1;
    @JvmField
    public int end = -1;

    @Nullable
    public final Segment getSegment$okio() {
        return this.segment;
    }

    public final void setSegment$okio(@Nullable Segment segment) {
        this.segment = segment;
    }

    public final int next() {
        Buffer$UnsafeCursor buffer$UnsafeCursor = this;
        boolean bl = false;
        long l = buffer$UnsafeCursor.offset;
        Buffer buffer = buffer$UnsafeCursor.buffer;
        Intrinsics.checkNotNull(buffer);
        if (!(l != buffer.size())) {
            boolean bl2 = false;
            String string = "no more bytes";
            throw new IllegalStateException(string.toString());
        }
        return buffer$UnsafeCursor.offset == -1L ? buffer$UnsafeCursor.seek(0L) : buffer$UnsafeCursor.seek(buffer$UnsafeCursor.offset + (long)(buffer$UnsafeCursor.end - buffer$UnsafeCursor.start));
    }

    public final int seek(long l) {
        int n;
        Buffer$UnsafeCursor buffer$UnsafeCursor = this;
        boolean bl = false;
        Buffer buffer = buffer$UnsafeCursor.buffer;
        if (buffer == null) {
            boolean bl2 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        Buffer buffer2 = buffer;
        if (l < -1L || l > buffer2.size()) {
            throw new ArrayIndexOutOfBoundsException("offset=" + l + " > size=" + buffer2.size());
        }
        if (l == -1L || l == buffer2.size()) {
            buffer$UnsafeCursor.setSegment$okio(null);
            buffer$UnsafeCursor.offset = l;
            buffer$UnsafeCursor.data = null;
            buffer$UnsafeCursor.start = -1;
            buffer$UnsafeCursor.end = -1;
            n = -1;
        } else {
            long l2 = 0L;
            long l3 = buffer2.size();
            Segment segment = buffer2.head;
            Segment segment2 = buffer2.head;
            if (buffer$UnsafeCursor.getSegment$okio() != null) {
                long l4 = buffer$UnsafeCursor.offset;
                int n2 = buffer$UnsafeCursor.start;
                Segment segment3 = buffer$UnsafeCursor.getSegment$okio();
                Intrinsics.checkNotNull(segment3);
                long l5 = l4 - (long)(n2 - segment3.pos);
                if (l5 > l) {
                    l3 = l5;
                    segment2 = buffer$UnsafeCursor.getSegment$okio();
                } else {
                    l2 = l5;
                    segment = buffer$UnsafeCursor.getSegment$okio();
                }
            }
            Segment segment4 = null;
            long l6 = 0L;
            if (l3 - l > l - l2) {
                segment4 = segment;
                l6 = l2;
                while (true) {
                    Segment segment5 = segment4;
                    Intrinsics.checkNotNull(segment5);
                    if (l >= l6 + (long)(segment5.limit - segment4.pos)) {
                        l6 += (long)(segment4.limit - segment4.pos);
                        segment4 = segment4.next;
                        continue;
                    }
                    break;
                }
            } else {
                Segment segment6;
                segment4 = segment2;
                for (l6 = l3; l6 > l; l6 -= (long)(segment6.limit - segment4.pos)) {
                    Segment segment7 = segment4;
                    Intrinsics.checkNotNull(segment7);
                    segment6 = segment4 = segment7.prev;
                    Intrinsics.checkNotNull(segment6);
                }
            }
            if (buffer$UnsafeCursor.readWrite) {
                Segment segment8 = segment4;
                Intrinsics.checkNotNull(segment8);
                if (segment8.shared) {
                    Segment segment9 = segment4.unsharedCopy();
                    if (buffer2.head == segment4) {
                        buffer2.head = segment9;
                    }
                    segment4 = segment4.push(segment9);
                    Segment segment10 = segment4.prev;
                    Intrinsics.checkNotNull(segment10);
                    segment10.pop();
                }
            }
            buffer$UnsafeCursor.setSegment$okio(segment4);
            buffer$UnsafeCursor.offset = l;
            Segment segment11 = segment4;
            Intrinsics.checkNotNull(segment11);
            buffer$UnsafeCursor.data = segment11.data;
            buffer$UnsafeCursor.start = segment4.pos + (int)(l - l6);
            buffer$UnsafeCursor.end = segment4.limit;
            n = buffer$UnsafeCursor.end - buffer$UnsafeCursor.start;
        }
        return n;
    }

    public final long resizeBuffer(long l) {
        Buffer$UnsafeCursor buffer$UnsafeCursor = this;
        boolean bl = false;
        Buffer buffer = buffer$UnsafeCursor.buffer;
        if (buffer == null) {
            boolean bl2 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        Buffer buffer2 = buffer;
        if (!buffer$UnsafeCursor.readWrite) {
            boolean bl3 = false;
            String string = "resizeBuffer() only permitted for read/write buffers";
            throw new IllegalStateException(string.toString());
        }
        long l2 = buffer2.size();
        if (l <= l2) {
            int n;
            if (!(l >= 0L)) {
                boolean bl4 = false;
                String string = "newSize < 0: " + l;
                throw new IllegalArgumentException(string.toString());
            }
            for (long i = l2 - l; i > 0L; i -= (long)n) {
                Segment segment;
                Segment segment2 = buffer2.head;
                Intrinsics.checkNotNull(segment2);
                Segment segment3 = segment = segment2.prev;
                Intrinsics.checkNotNull(segment3);
                n = segment3.limit - segment.pos;
                if ((long)n <= i) {
                    buffer2.head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.limit -= (int)i;
                break;
            }
            buffer$UnsafeCursor.setSegment$okio(null);
            buffer$UnsafeCursor.offset = l;
            buffer$UnsafeCursor.data = null;
            buffer$UnsafeCursor.start = -1;
            buffer$UnsafeCursor.end = -1;
        } else if (l > l2) {
            int n;
            boolean bl5 = true;
            for (long i = l - l2; i > 0L; i -= (long)n) {
                Segment segment = buffer2.writableSegment$okio(1);
                int n2 = 8192 - segment.limit;
                boolean bl6 = false;
                n = (int)Math.min(i, (long)n2);
                segment.limit += n;
                if (!bl5) continue;
                buffer$UnsafeCursor.setSegment$okio(segment);
                buffer$UnsafeCursor.offset = l2;
                buffer$UnsafeCursor.data = segment.data;
                buffer$UnsafeCursor.start = segment.limit - n;
                buffer$UnsafeCursor.end = segment.limit;
                bl5 = false;
            }
        }
        buffer2.setSize$okio(l);
        return l2;
    }

    public final long expandBuffer(int n) {
        Buffer$UnsafeCursor buffer$UnsafeCursor = this;
        boolean bl = false;
        if (!(n > 0)) {
            boolean bl2 = false;
            String string = "minByteCount <= 0: " + n;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n <= 8192)) {
            boolean bl3 = false;
            String string = "minByteCount > Segment.SIZE: " + n;
            throw new IllegalArgumentException(string.toString());
        }
        Buffer buffer = buffer$UnsafeCursor.buffer;
        if (buffer == null) {
            boolean bl4 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        Buffer buffer2 = buffer;
        if (!buffer$UnsafeCursor.readWrite) {
            boolean bl5 = false;
            String string = "expandBuffer() only permitted for read/write buffers";
            throw new IllegalStateException(string.toString());
        }
        long l = buffer2.size();
        Segment segment = buffer2.writableSegment$okio(n);
        int n2 = 8192 - segment.limit;
        segment.limit = 8192;
        buffer2.setSize$okio(l + (long)n2);
        buffer$UnsafeCursor.setSegment$okio(segment);
        buffer$UnsafeCursor.offset = l;
        buffer$UnsafeCursor.data = segment.data;
        buffer$UnsafeCursor.start = 8192 - n2;
        buffer$UnsafeCursor.end = 8192;
        return n2;
    }

    @Override
    public void close() {
        Buffer$UnsafeCursor buffer$UnsafeCursor = this;
        boolean bl = false;
        if (!(buffer$UnsafeCursor.buffer != null)) {
            boolean bl2 = false;
            String string = "not attached to a buffer";
            throw new IllegalStateException(string.toString());
        }
        buffer$UnsafeCursor.buffer = null;
        buffer$UnsafeCursor.setSegment$okio(null);
        buffer$UnsafeCursor.offset = -1L;
        buffer$UnsafeCursor.data = null;
        buffer$UnsafeCursor.start = -1;
        buffer$UnsafeCursor.end = -1;
    }
}

