/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.input.ReversedLinesFileReader$FilePart;

public class ReversedLinesFileReader
implements Closeable {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final int blockSize;
    private final Charset charset;
    private final SeekableByteChannel channel;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private ReversedLinesFileReader$FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped;

    @Deprecated
    public ReversedLinesFileReader(File file) {
        this(file, 8192, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file, Charset charset) {
        this(file.toPath(), charset);
    }

    public ReversedLinesFileReader(File file, int n, Charset charset) {
        this(file.toPath(), n, charset);
    }

    public ReversedLinesFileReader(File file, int n, String string) {
        this(file.toPath(), n, string);
    }

    public ReversedLinesFileReader(Path path, Charset charset) {
        this(path, 8192, charset);
    }

    public ReversedLinesFileReader(Path path, int n, Charset charset) {
        this.blockSize = n;
        this.charset = Charsets.toCharset(charset);
        CharsetEncoder charsetEncoder = this.charset.newEncoder();
        float f = charsetEncoder.maxBytesPerChar();
        if (f == 1.0f) {
            this.byteDecrement = 1;
        } else if (this.charset == StandardCharsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (this.charset == Charset.forName("Shift_JIS") || this.charset == Charset.forName("windows-31j") || this.charset == Charset.forName("x-windows-949") || this.charset == Charset.forName("gbk") || this.charset == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (this.charset == StandardCharsets.UTF_16BE || this.charset == StandardCharsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (this.charset == StandardCharsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{StandardLineSeparator.CRLF.getBytes(this.charset), StandardLineSeparator.LF.getBytes(this.charset), StandardLineSeparator.CR.getBytes(this.charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.channel = Files.newByteChannel(path, StandardOpenOption.READ);
        this.totalByteLength = this.channel.size();
        int n2 = (int)(this.totalByteLength % (long)n);
        if (n2 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)n + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)n;
            if (this.totalByteLength > 0L) {
                n2 = n;
            }
        }
        this.currentFilePart = new ReversedLinesFileReader$FilePart(this, this.totalBlockCount, n2, null, null);
    }

    public ReversedLinesFileReader(Path path, int n, String string) {
        this(path, n, Charsets.toCharset(string));
    }

    @Override
    public void close() {
        this.channel.close();
    }

    public String readLine() {
        String string = ReversedLinesFileReader$FilePart.access$700(this.currentFilePart);
        while (string == null) {
            this.currentFilePart = ReversedLinesFileReader$FilePart.access$800(this.currentFilePart);
            if (this.currentFilePart == null) break;
            string = ReversedLinesFileReader$FilePart.access$700(this.currentFilePart);
        }
        if (EMPTY_STRING.equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    public List<String> readLines(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("lineCount < 0");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.readLine();
            if (string == null) {
                return arrayList;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public String toString(int n) {
        List<String> list = this.readLines(n);
        Collections.reverse(list);
        return list.isEmpty() ? EMPTY_STRING : String.join((CharSequence)System.lineSeparator(), list) + System.lineSeparator();
    }

    static /* synthetic */ int access$000(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.blockSize;
    }

    static /* synthetic */ SeekableByteChannel access$100(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.channel;
    }

    static /* synthetic */ byte[][] access$200(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.newLineSequences;
    }

    static /* synthetic */ int access$300(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.avoidNewlineSplitBufferSize;
    }

    static /* synthetic */ Charset access$400(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.charset;
    }

    static /* synthetic */ int access$500(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.byteDecrement;
    }
}

