/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch$SplitState;
import org.apache.commons.lang3.time.StopWatch$State;

public class StopWatch {
    private static final long NANO_2_MILLIS = 1000000L;
    private final String message;
    private StopWatch$State runningState = StopWatch$State.UNSTARTED;
    private StopWatch$SplitState splitState = StopWatch$SplitState.UNSPLIT;
    private long startTimeNanos;
    private long startTimeMillis;
    private long stopTimeMillis;
    private long stopTimeNanos;

    public static StopWatch create() {
        return new StopWatch();
    }

    public static StopWatch createStarted() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public StopWatch() {
        this(null);
    }

    public StopWatch(String string) {
        this.message = string;
    }

    public String formatSplitTime() {
        return DurationFormatUtils.formatDurationHMS(this.getSplitTime());
    }

    public String formatTime() {
        return DurationFormatUtils.formatDurationHMS(this.getTime());
    }

    public String getMessage() {
        return this.message;
    }

    public long getNanoTime() {
        if (this.runningState == StopWatch$State.STOPPED || this.runningState == StopWatch$State.SUSPENDED) {
            return this.stopTimeNanos - this.startTimeNanos;
        }
        if (this.runningState == StopWatch$State.UNSTARTED) {
            return 0L;
        }
        if (this.runningState == StopWatch$State.RUNNING) {
            return System.nanoTime() - this.startTimeNanos;
        }
        throw new IllegalStateException("Illegal running state has occurred.");
    }

    public long getSplitNanoTime() {
        if (this.splitState != StopWatch$SplitState.SPLIT) {
            throw new IllegalStateException("Stopwatch must be split to get the split time.");
        }
        return this.stopTimeNanos - this.startTimeNanos;
    }

    public long getSplitTime() {
        return this.getSplitNanoTime() / 1000000L;
    }

    public long getStartTime() {
        if (this.runningState == StopWatch$State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.startTimeMillis;
    }

    public long getStopTime() {
        if (this.runningState == StopWatch$State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.stopTimeMillis;
    }

    public long getTime() {
        return this.getNanoTime() / 1000000L;
    }

    public long getTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.getNanoTime(), TimeUnit.NANOSECONDS);
    }

    public boolean isStarted() {
        return this.runningState.isStarted();
    }

    public boolean isStopped() {
        return this.runningState.isStopped();
    }

    public boolean isSuspended() {
        return this.runningState.isSuspended();
    }

    public void reset() {
        this.runningState = StopWatch$State.UNSTARTED;
        this.splitState = StopWatch$SplitState.UNSPLIT;
    }

    public void resume() {
        if (this.runningState != StopWatch$State.SUSPENDED) {
            throw new IllegalStateException("Stopwatch must be suspended to resume. ");
        }
        this.startTimeNanos += System.nanoTime() - this.stopTimeNanos;
        this.runningState = StopWatch$State.RUNNING;
    }

    public void split() {
        if (this.runningState != StopWatch$State.RUNNING) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        this.stopTimeNanos = System.nanoTime();
        this.splitState = StopWatch$SplitState.SPLIT;
    }

    public void start() {
        if (this.runningState == StopWatch$State.STOPPED) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted. ");
        }
        if (this.runningState != StopWatch$State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch already started. ");
        }
        this.startTimeNanos = System.nanoTime();
        this.startTimeMillis = System.currentTimeMillis();
        this.runningState = StopWatch$State.RUNNING;
    }

    public void stop() {
        if (this.runningState != StopWatch$State.RUNNING && this.runningState != StopWatch$State.SUSPENDED) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        if (this.runningState == StopWatch$State.RUNNING) {
            this.stopTimeNanos = System.nanoTime();
            this.stopTimeMillis = System.currentTimeMillis();
        }
        this.runningState = StopWatch$State.STOPPED;
    }

    public void suspend() {
        if (this.runningState != StopWatch$State.RUNNING) {
            throw new IllegalStateException("Stopwatch must be running to suspend. ");
        }
        this.stopTimeNanos = System.nanoTime();
        this.stopTimeMillis = System.currentTimeMillis();
        this.runningState = StopWatch$State.SUSPENDED;
    }

    public String toSplitString() {
        String string = Objects.toString(this.message, "");
        String string2 = this.formatSplitTime();
        return string.isEmpty() ? string2 : string + " " + string2;
    }

    public String toString() {
        String string = Objects.toString(this.message, "");
        String string2 = this.formatTime();
        return string.isEmpty() ? string2 : string + " " + string2;
    }

    public void unsplit() {
        if (this.splitState != StopWatch$SplitState.SPLIT) {
            throw new IllegalStateException("Stopwatch has not been split. ");
        }
        this.splitState = StopWatch$SplitState.UNSPLIT;
    }
}

